/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedBrowsableEndpointAsXmlFileTest
extends ManagementTestSupport {
    @Test
    public void testBrowseableEndpointAsXmlAllIncludeBody() throws Exception {
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = this.getCamelObjectName("endpoints", "file://" + this.testDirectory());
        String out = (String)mbeanServer.invoke(name, "browseAllMessagesAsXml", new Object[]{true}, new String[]{"java.lang.Boolean"});
        Assertions.assertNotNull((Object)out);
        this.log.info(out);
        Assertions.assertTrue((boolean)out.contains("Hello World</body>"), (String)"Should contain the body");
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ManagedBrowsableEndpointAsXmlFileTest.this.context.setUseBreadcrumb(Boolean.valueOf(false));
                this.from("direct:start").to(ManagedBrowsableEndpointAsXmlFileTest.this.fileUri());
            }
        };
    }
}

