/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedDefaultReactiveExecutorTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getReactiveExecutor().setStatisticsEnabled(true);
        return context;
    }

    @Test
    public void testReactiveExecutor() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:start").to("log:foo")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        MBeanServer mbeanServer = ManagedDefaultReactiveExecutorTest.this.getMBeanServer();
                        ObjectName on = ManagedDefaultReactiveExecutorTest.this.getCamelObjectName("services", "DefaultReactiveExecutor");
                        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
                        Integer running = (Integer)mbeanServer.getAttribute(on, "RunningWorkers");
                        Assertions.assertEquals((int)1, (int)running);
                        Integer pending = (Integer)mbeanServer.getAttribute(on, "PendingTasks");
                        Assertions.assertEquals((int)0, (int)pending);
                    }
                })).to("log:bar")).to("mock:result");
            }
        };
    }
}

