/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedInterceptTest
extends ManagementTestSupport {
    @Test
    public void testIntercept() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:intercept").expectedBodiesReceived(new Object[]{"Hello World", "Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = this.getCamelObjectName("endpoints", "mock://result");
        Long queueSize = (Long)mbeanServer.invoke(name, "queueSize", null, null);
        Assertions.assertEquals((int)1, (int)queueSize.intValue());
        name = this.getCamelObjectName("endpoints", "mock://intercept");
        queueSize = (Long)mbeanServer.invoke(name, "queueSize", null, null);
        Assertions.assertEquals((int)2, (int)queueSize.intValue());
        name = this.getCamelObjectName("processors", "log-foo");
        mbeanServer.isRegistered(name);
        Long total = (Long)mbeanServer.getAttribute(name, "ExchangesTotal");
        Assertions.assertEquals((int)1, (int)total.intValue());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.intercept().to("mock:intercept");
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").to("log:foo")).id("log-foo")).to("mock:result");
            }
        };
    }
}

