/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.AttributeValueExp;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedResetIncludeProcessorsTest
extends ManagementTestSupport {
    @Test
    public void testReset() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        QueryExp queryExp = Query.match(new AttributeValueExp("RouteId"), new StringValueExp("first"));
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), queryExp);
        Assertions.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBody("direct:start", (Object)"B");
        this.template.sendBody("direct:start", (Object)"C");
        this.template.sendBody("direct:start", (Object)"D");
        this.template.sendBody("direct:start", (Object)"E");
        this.template.sendBody("direct:baz", (Object)"F");
        this.assertMockEndpointsSatisfied();
        Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        Assertions.assertEquals((long)5L, (long)completed);
        set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), queryExp);
        Assertions.assertEquals((int)3, (int)set.size());
        for (ObjectName name : set) {
            completed = (Long)mbeanServer.getAttribute(name, "ExchangesCompleted");
            Assertions.assertEquals((long)5L, (long)completed);
        }
        mbeanServer.invoke(on, "reset", new Object[]{true}, new String[]{"boolean"});
        completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        Assertions.assertEquals((long)0L, (long)completed);
        set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), queryExp);
        Assertions.assertEquals((int)3, (int)set.size());
        for (ObjectName name : set) {
            completed = (Long)mbeanServer.getAttribute(name, "ExchangesCompleted");
            Assertions.assertEquals((long)0L, (long)completed);
        }
        queryExp = Query.match(new AttributeValueExp("RouteId"), new StringValueExp("second"));
        set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), queryExp);
        Assertions.assertEquals((int)1, (int)set.size());
        on = set.iterator().next();
        completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        Assertions.assertEquals((long)1L, (long)completed);
        set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), queryExp);
        Assertions.assertEquals((int)1, (int)set.size());
        for (ObjectName name : set) {
            completed = (Long)mbeanServer.getAttribute(name, "ExchangesCompleted");
            Assertions.assertEquals((long)1L, (long)completed);
        }
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("first").to("log:foo")).id("foo")).to("log:bar")).id("bar")).to("mock:result")).id("mock");
                ((RouteDefinition)this.from("direct:baz").routeId("second").to("mock:baz")).id("baz");
            }
        };
    }
}

