/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.PublishEventNotifier;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.EventNotifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PublishEventNotifierToRouteTest
extends ContextTestSupport {
    protected boolean useJmx() {
        return true;
    }

    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext(this.createRegistry());
        PublishEventNotifier notifier = new PublishEventNotifier();
        notifier.setCamelContext((CamelContext)context);
        notifier.setEndpointUri("seda:event");
        context.getManagementStrategy().addEventNotifier((EventNotifier)notifier);
        return context;
    }

    @Test
    public void testExchangeDone() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:event").expectedMinimumMessageCount(6);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testExchangeFailed() throws Exception {
        this.getMockEndpoint("mock:event").expectedMinimumMessageCount(4);
        try {
            this.template.sendBody("direct:fail", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            PublishEventNotifierToRouteTest.assertIsInstanceOf(IllegalArgumentException.class, (Object)e.getCause());
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
                this.from("direct:fail").throwException((Exception)new IllegalArgumentException("Damn"));
                ((RouteDefinition)this.from("seda:event").log("Event ${body}")).to("mock:event");
            }
        };
    }
}

