/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ServiceStatus;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.JmxManagementStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedDualCamelContextTest
extends TestSupport {
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        return context;
    }

    @Test
    public void testDualCamelContext() throws Exception {
        CamelContext camel1 = this.createCamelContext();
        camel1.start();
        CamelContext camel2 = this.createCamelContext();
        camel2.start();
        ManagedDualCamelContextTest.assertIsInstanceOf(JmxManagementStrategy.class, (Object)camel1.getManagementStrategy());
        ManagedDualCamelContextTest.assertIsInstanceOf(JmxManagementStrategy.class, (Object)camel2.getManagementStrategy());
        MBeanServer mbeanServer1 = camel1.getManagementStrategy().getManagementAgent().getMBeanServer();
        Set<ObjectName> set = mbeanServer1.queryNames(new ObjectName("*:context=" + camel1.getManagementName() + ",type=components,*"), null);
        Assertions.assertEquals((int)2, (int)set.size());
        ObjectName on = set.iterator().next();
        Assertions.assertTrue((boolean)mbeanServer1.isRegistered(on), (String)"Should be registered");
        String state = (String)mbeanServer1.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        String id = (String)mbeanServer1.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)camel1.getManagementName(), (Object)id);
        MBeanServer mbeanServer2 = camel2.getManagementStrategy().getManagementAgent().getMBeanServer();
        set = mbeanServer1.queryNames(new ObjectName("*:context=" + camel2.getManagementName() + ",type=components,*"), null);
        Assertions.assertEquals((int)2, (int)set.size());
        on = set.iterator().next();
        Assertions.assertTrue((boolean)mbeanServer2.isRegistered(on), (String)"Should be registered");
        state = (String)mbeanServer2.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        id = (String)mbeanServer2.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)camel2.getManagementName(), (Object)id);
        camel1.stop();
        camel2.stop();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

