/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.MessageHistory;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.StepDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedMessageHistoryTest
extends ManagementTestSupport {
    @Test
    public void testStepOnly() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        Exchange out = this.template.request("direct:start", e -> e.getMessage().setBody((Object)"Hello World"));
        this.assertMockEndpointsSatisfied();
        List history = (List)out.getProperty("CamelMessageHistory", List.class);
        Assertions.assertNotNull((Object)history);
        Assertions.assertEquals((int)3, (int)history.size());
        Assertions.assertEquals((Object)"step", (Object)((MessageHistory)history.get(0)).getNode().getShortName());
        Assertions.assertEquals((Object)"a", (Object)((MessageHistory)history.get(0)).getNode().getId());
        Assertions.assertEquals((Object)"step", (Object)((MessageHistory)history.get(1)).getNode().getShortName());
        Assertions.assertEquals((Object)"b", (Object)((MessageHistory)history.get(1)).getNode().getId());
        Assertions.assertEquals((Object)"step", (Object)((MessageHistory)history.get(2)).getNode().getShortName());
        Assertions.assertEquals((Object)"bar", (Object)((MessageHistory)history.get(2)).getNode().getId());
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
        String name = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)this.context.getName(), (Object)name);
        Boolean mh = (Boolean)mbeanServer.getAttribute(on, "MessageHistory");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)mh);
        on = this.getCamelObjectName("services", "DefaultMessageHistoryFactory");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
        Boolean en = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)en);
        Boolean cm = (Boolean)mbeanServer.getAttribute(on, "CopyMessage");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)cm);
        String np = (String)mbeanServer.getAttribute(on, "NodePattern");
        Assertions.assertEquals((Object)"step", (Object)np);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ManagedMessageHistoryTest.this.context.setMessageHistory(Boolean.valueOf(true));
                ManagedMessageHistoryTest.this.context.getMessageHistoryFactory().setNodePattern("step");
                ((StepDefinition)((StepDefinition)((StepDefinition)((StepDefinition)this.from("direct:start").step("a").to("log:foo")).to("mock:a")).end().step("b").to("direct:bar")).to("mock:b")).end();
                ((StepDefinition)((StepDefinition)this.from("direct:bar").step("bar").to("log:bar")).to("mock:bar")).end();
            }
        };
    }
}

