/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedRouteStopUsingMBeanAPITest
extends ManagementTestSupport {
    @Test
    public void testStopRoute() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        Assertions.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        ManagedRouteMBean mbean = (ManagedRouteMBean)this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedRouteMBean.class);
        Assertions.assertEquals((Object)"direct://start", (Object)mbean.getEndpointUri());
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)mbean.getState(), (String)"Should be started");
        mbean.stop();
        Assertions.assertEquals((Object)ServiceStatus.Stopped.name(), (Object)mbean.getState(), (String)"Should be stopped");
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

