/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.TestSupport;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class TwoManagedCamelContextClashTest
extends TestSupport {
    private CamelContext camel1;
    private CamelContext camel2;

    protected CamelContext createCamelContext(String name, String managementPattern) throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.setName(name);
        if (managementPattern != null) {
            context.getManagementNameStrategy().setNamePattern(managementPattern);
        }
        return context;
    }

    @Test
    public void testTwoManagedCamelContextNoClashDefault() throws Exception {
        this.camel1 = this.createCamelContext("foo", null);
        this.camel2 = this.createCamelContext("foo", null);
        this.camel1.start();
        Assertions.assertTrue((boolean)this.camel1.getStatus().isStarted(), (String)"Should be started");
        MBeanServer mbeanServer = this.camel1.getManagementStrategy().getManagementAgent().getMBeanServer();
        ObjectName on = TwoManagedCamelContextClashTest.getContextObjectName(this.camel1);
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
        this.camel2.start();
        ObjectName on2 = TwoManagedCamelContextClashTest.getContextObjectName(this.camel2);
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on2), (String)"Should be registered");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should still be registered after name clash");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on2), (String)"Should still be registered after name clash");
    }

    @Test
    public void testTwoManagedCamelContextNoClashCustomPattern() throws Exception {
        this.camel1 = this.createCamelContext("foo", "killer-#counter#");
        this.camel2 = this.createCamelContext("foo", "killer-#counter#");
        this.camel1.start();
        Assertions.assertTrue((boolean)this.camel1.getStatus().isStarted(), (String)"Should be started");
        MBeanServer mbeanServer = this.camel1.getManagementStrategy().getManagementAgent().getMBeanServer();
        ObjectName on = TwoManagedCamelContextClashTest.getContextObjectName(this.camel1);
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
        this.camel2.start();
        ObjectName on2 = TwoManagedCamelContextClashTest.getContextObjectName(this.camel2);
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on2), (String)"Should be registered");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should still be registered after name clash");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on2), (String)"Should still be registered after name clash");
    }

    @Test
    public void testTwoManagedCamelContextClash() throws Exception {
        this.camel1 = this.createCamelContext("foo", "myFoo");
        this.camel2 = this.createCamelContext("foo", "myFoo");
        this.camel1.start();
        Assertions.assertTrue((boolean)this.camel1.getStatus().isStarted(), (String)"Should be started");
        MBeanServer mbeanServer = this.camel1.getManagementStrategy().getManagementAgent().getMBeanServer();
        ObjectName on = TwoManagedCamelContextClashTest.getContextObjectName(this.camel1);
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
        try {
            this.camel2.start();
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)e.getCause().getMessage().contains("is already registered"));
        }
    }

    private static ObjectName getContextObjectName(CamelContext context) throws MalformedObjectNameException {
        return ObjectName.getInstance("org.apache.camel:context=" + context.getManagementName() + ",type=context,name=\"" + context.getName() + "\"");
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.camel1 != null) {
            this.camel1.stop();
        }
        if (this.camel2 != null) {
            this.camel2.stop();
        }
        super.tearDown();
    }
}

