/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.List;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedRestRegistryMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.RestRegistry;

@ManagedResource(description="Managed RestRegistry")
public class ManagedRestRegistry
extends ManagedService
implements ManagedRestRegistryMBean {
    private final RestRegistry registry;

    public ManagedRestRegistry(CamelContext context, RestRegistry registry) {
        super(context, (Service)registry);
        this.registry = registry;
    }

    public RestRegistry getRegistry() {
        return this.registry;
    }

    public int getNumberOfRestServices() {
        return this.registry.size();
    }

    public TabularData listRestServices() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.listRestServicesTabularType());
            List services = this.registry.listAllRestServices();
            for (RestRegistry.RestService entry : services) {
                CompositeType ct = CamelOpenMBeanTypes.listRestServicesCompositeType();
                String url = entry.getUrl();
                String baseUrl = entry.getBaseUrl();
                String basePath = entry.getBasePath();
                String uriTemplate = entry.getUriTemplate();
                String method = entry.getMethod();
                String consumes = entry.getConsumes();
                String produces = entry.getProduces();
                String state = entry.getState();
                String inType = entry.getInType();
                String outType = entry.getOutType();
                String description = entry.getDescription();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"url", "baseUrl", "basePath", "uriTemplate", "method", "consumes", "produces", "inType", "outType", "state", "description"}, new Object[]{url, baseUrl, basePath, uriTemplate, method, consumes, produces, inType, outType, state, description});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public String apiDocAsJson() {
        return this.registry.apiDocAsJson();
    }
}

