/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedThrottlerMBean;
import org.apache.camel.builder.Builder;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.Throttler;

@ManagedResource(description="Managed Throttler")
public class ManagedThrottler
extends ManagedProcessor
implements ManagedThrottlerMBean {
    private final Throttler throttler;

    public ManagedThrottler(CamelContext context, Throttler throttler, ProcessorDefinition<?> definition) {
        super(context, (Processor)throttler, definition);
        this.throttler = throttler;
    }

    public Throttler getThrottler() {
        return this.throttler;
    }

    public long getMaximumConcurrentRequests() {
        return this.throttler.getCurrentMaximumConcurrentRequests();
    }

    public void setMaximumConcurrentRequests(long maximumConcurrentRequests) {
        this.throttler.setMaximumConcurrentRequestsExpression((Expression)Builder.constant((Object)maximumConcurrentRequests));
    }

    public Boolean isAsyncDelayed() {
        return this.throttler.isAsyncDelayed();
    }

    public Boolean isCallerRunsWhenRejected() {
        return this.throttler.isCallerRunsWhenRejected();
    }

    public Boolean isRejectExecution() {
        return this.throttler.isRejectExecution();
    }
}

