/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Collection;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedAsyncProcessorAwaitManagerMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.AsyncProcessorAwaitManager;

@ManagedResource(description="Managed AsyncProcessorAwaitManager")
public class ManagedAsyncProcessorAwaitManager
extends ManagedService
implements ManagedAsyncProcessorAwaitManagerMBean {
    private final AsyncProcessorAwaitManager manager;

    public ManagedAsyncProcessorAwaitManager(CamelContext context, AsyncProcessorAwaitManager manager) {
        super(context, (Service)manager);
        this.manager = manager;
    }

    public AsyncProcessorAwaitManager getAsyncProcessorAwaitManager() {
        return this.manager;
    }

    public boolean isInterruptThreadsWhileStopping() {
        return this.manager.isInterruptThreadsWhileStopping();
    }

    public void setInterruptThreadsWhileStopping(boolean interruptThreadsWhileStopping) {
        this.manager.setInterruptThreadsWhileStopping(interruptThreadsWhileStopping);
    }

    public int getSize() {
        return this.manager.size();
    }

    public TabularData browse() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.listAwaitThreadsTabularType());
            Collection threads = this.manager.browse();
            for (AsyncProcessorAwaitManager.AwaitThread entry : threads) {
                CompositeType ct = CamelOpenMBeanTypes.listAwaitThreadsCompositeType();
                String id = Long.toString(entry.getBlockedThread().getId());
                String name = entry.getBlockedThread().getName();
                String exchangeId = entry.getExchange().getExchangeId();
                String routeId = entry.getRouteId();
                String nodeId = entry.getNodeId();
                String duration = Long.toString(entry.getWaitDuration());
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"id", "name", "exchangeId", "routeId", "nodeId", "duration"}, new Object[]{id, name, exchangeId, routeId, nodeId, duration});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public void interrupt(String exchangeId) {
        this.manager.interrupt(exchangeId);
    }

    public long getThreadsBlocked() {
        return this.manager.getStatistics().getThreadsBlocked();
    }

    public long getThreadsInterrupted() {
        return this.manager.getStatistics().getThreadsInterrupted();
    }

    public long getTotalDuration() {
        return this.manager.getStatistics().getTotalDuration();
    }

    public long getMinDuration() {
        return this.manager.getStatistics().getMinDuration();
    }

    public long getMaxDuration() {
        return this.manager.getStatistics().getMaxDuration();
    }

    public long getMeanDuration() {
        return this.manager.getStatistics().getMeanDuration();
    }

    public void resetStatistics() {
        this.manager.getStatistics().reset();
    }

    public boolean isStatisticsEnabled() {
        return this.manager.getStatistics().isStatisticsEnabled();
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.manager.getStatistics().setStatisticsEnabled(statisticsEnabled);
    }
}

