/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Collection;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedTransformerRegistryMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.TransformerRegistry;

@ManagedResource(description="Managed TransformerRegistry")
public class ManagedTransformerRegistry
extends ManagedService
implements ManagedTransformerRegistryMBean {
    private final TransformerRegistry<?> transformerRegistry;

    public ManagedTransformerRegistry(CamelContext context, TransformerRegistry<?> transformerRegistry) {
        super(context, (Service)transformerRegistry);
        this.transformerRegistry = transformerRegistry;
    }

    public TransformerRegistry<?> getTransformerRegistry() {
        return this.transformerRegistry;
    }

    public String getSource() {
        return this.transformerRegistry.toString();
    }

    public Integer getDynamicSize() {
        return this.transformerRegistry.dynamicSize();
    }

    public Integer getStaticSize() {
        return this.transformerRegistry.staticSize();
    }

    public Integer getSize() {
        return this.transformerRegistry.size();
    }

    public Integer getMaximumCacheSize() {
        return this.transformerRegistry.getMaximumCacheSize();
    }

    public void purge() {
        this.transformerRegistry.purge();
    }

    public TabularData listTransformers() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.listTransformersTabularType());
            Collection transformers = this.transformerRegistry.values();
            for (Transformer transformer : transformers) {
                CompositeType ct = CamelOpenMBeanTypes.listTransformersCompositeType();
                String name = transformer.getName();
                DataType from = transformer.getFrom();
                DataType to = transformer.getTo();
                String desc = transformer.toString();
                boolean fromStatic = name != null ? this.transformerRegistry.isStatic(name) : this.transformerRegistry.isStatic(from, to);
                boolean fromDynamic = name != null ? this.transformerRegistry.isDynamic(name) : this.transformerRegistry.isDynamic(from, to);
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"name", "from", "to", "static", "dynamic", "description"}, new Object[]{name, from.toString(), to.toString(), fromStatic, fromDynamic, desc});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

