/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.List;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.BacklogTracerEventMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class BacklogTracerFilterTest
extends ManagementTestSupport {
    @Test
    public void testBacklogTracerFilter() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogTracer");
        Assertions.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        Integer size = (Integer)mbeanServer.getAttribute(on, "BacklogSize");
        Assertions.assertEquals((int)1000, (int)size, (String)"Should be 1000");
        mbeanServer.setAttribute(on, new Attribute("TraceFilter", "${header.foo} != null"));
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "foo", (Object)123);
        this.assertMockEndpointsSatisfied();
        List exchanges = this.getMockEndpoint("mock:foo").getReceivedExchanges();
        List events = (List)mbeanServer.invoke(on, "dumpAllTracedMessages", null, null);
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)4, (int)events.size());
        BacklogTracerEventMessage event = (BacklogTracerEventMessage)events.get(0);
        Assertions.assertNull((Object)event.getToNode());
        Assertions.assertEquals((Object)("    <message exchangeId=\"" + ((Exchange)exchanges.get(1)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n      <headers>\n        <header key=\"foo\" type=\"java.lang.Integer\">123</header>\n      </headers>\n      <body type=\"java.lang.String\">Bye World</body>\n    </message>"), (Object)event.getMessageAsXml());
        BacklogTracerEventMessage event1 = (BacklogTracerEventMessage)events.get(1);
        Assertions.assertEquals((Object)"foo", (Object)event1.getToNode());
        Assertions.assertEquals((Object)("    <message exchangeId=\"" + ((Exchange)exchanges.get(1)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n      <headers>\n        <header key=\"foo\" type=\"java.lang.Integer\">123</header>\n      </headers>\n      <body type=\"java.lang.String\">Bye World</body>\n    </message>"), (Object)event1.getMessageAsXml());
        BacklogTracerEventMessage event2 = (BacklogTracerEventMessage)events.get(2);
        Assertions.assertEquals((Object)"bar", (Object)event2.getToNode());
        Assertions.assertEquals((Object)("    <message exchangeId=\"" + ((Exchange)exchanges.get(1)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n      <headers>\n        <header key=\"foo\" type=\"java.lang.Integer\">123</header>\n      </headers>\n      <body type=\"java.lang.String\">Bye World</body>\n    </message>"), (Object)event2.getMessageAsXml());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                BacklogTracerFilterTest.this.context.setUseBreadcrumb(Boolean.valueOf(false));
                BacklogTracerFilterTest.this.context.setBacklogTracingStandby(true);
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:foo")).id("foo")).to("mock:bar")).id("bar");
            }
        };
    }
}

