/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class JmxRecipientListTest
extends ManagementTestSupport {
    @Test
    public void testJmxEndpointsAddedDynamicallyDefaultRegister() throws Exception {
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedBodiesReceived(new Object[]{"answer"});
        y.expectedBodiesReceived(new Object[]{"answer"});
        z.expectedBodiesReceived(new Object[]{"answer"});
        this.sendBody();
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = this.getCamelObjectName("endpoints", "direct://a");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(name), (String)"Should be registered");
        name = this.getCamelObjectName("endpoints", "mock://x");
        Assertions.assertFalse((boolean)mbeanServer.isRegistered(name), (String)"Should not be registered");
        name = this.getCamelObjectName("endpoints", "mock://y");
        Assertions.assertFalse((boolean)mbeanServer.isRegistered(name), (String)"Should not be registered");
        name = this.getCamelObjectName("endpoints", "mock://z");
        Assertions.assertFalse((boolean)mbeanServer.isRegistered(name), (String)"Should not be registered");
        name = this.getCamelObjectName("components", "mock");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(name), (String)"Should be registered");
    }

    @Test
    public void testJmxEndpointsAddedDynamicallyAlwaysRegister() throws Exception {
        this.context.getManagementStrategy().getManagementAgent().setRegisterAlways(Boolean.valueOf(true));
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedBodiesReceived(new Object[]{"answer"});
        y.expectedBodiesReceived(new Object[]{"answer"});
        z.expectedBodiesReceived(new Object[]{"answer"});
        this.sendBody();
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = this.getCamelObjectName("endpoints", "direct://a");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(name), (String)("Should be registered: " + String.valueOf(name)));
        name = this.getCamelObjectName("endpoints", "mock://x");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(name), (String)("Should be registered: " + String.valueOf(name)));
        name = this.getCamelObjectName("endpoints", "mock://y");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(name), (String)("Should be registered: " + String.valueOf(name)));
        name = this.getCamelObjectName("endpoints", "mock://z");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(name), (String)("Should be registered: " + String.valueOf(name)));
        name = this.getCamelObjectName("components", "mock");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(name), (String)("Should be registered: " + String.valueOf(name)));
    }

    protected void sendBody() {
        this.template.sendBodyAndHeader("direct:a", (Object)"answer", "recipientListHeader", (Object)"mock:x,mock:y,mock:z");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").recipientList((Expression)this.header("recipientListHeader").tokenize(","));
            }
        };
    }
}

