/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.HashMap;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedRouteAddRemoveTest
extends ManagementTestSupport {
    private static final int SERVICES = 16;

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("foo").to("mock:result");
            }
        };
    }

    @Test
    public void testRouteAddRemoteRouteWithTo() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        result.assertIsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("services", "*");
        Set<ObjectName> names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)16, (int)names.size());
        ObjectName onP = this.getCamelObjectName("producers", "*");
        Set<ObjectName> namesP = mbeanServer.queryNames(onP, null);
        Assertions.assertEquals((int)1, (int)namesP.size());
        this.log.info("Adding 2nd route");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:bar").routeId("bar").to("mock:bar");
            }
        });
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMessageCount(1);
        this.template.sendBody("direct:bar", (Object)"Hello World");
        bar.assertIsSatisfied();
        names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)16, (int)names.size());
        namesP = mbeanServer.queryNames(onP, null);
        Assertions.assertEquals((int)2, (int)namesP.size());
        this.log.info("Removing 2nd route");
        this.context.getRouteController().stopRoute("bar");
        boolean removed = this.context.removeRoute("bar");
        Assertions.assertTrue((boolean)removed);
        names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)16, (int)names.size());
        namesP = mbeanServer.queryNames(onP, null);
        Assertions.assertEquals((int)1, (int)namesP.size());
        this.log.info("Shutting down...");
    }

    @Test
    public void testRouteAddRemoteRouteWithRecipientList() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        result.assertIsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("services", "*");
        Set<ObjectName> names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)16, (int)names.size());
        ObjectName onP = this.getCamelObjectName("producers", "*");
        Set<ObjectName> namesP = mbeanServer.queryNames(onP, null);
        Assertions.assertEquals((int)1, (int)namesP.size());
        this.log.info("Adding 2nd route");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:bar").routeId("bar").recipientList((Expression)this.header("bar"));
            }
        });
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:bar", (Object)"Hello World", "bar", (Object)"mock:bar");
        bar.assertIsSatisfied();
        names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)16, (int)names.size());
        namesP = mbeanServer.queryNames(onP, null);
        Assertions.assertEquals((int)1, (int)namesP.size());
        this.log.info("Removing 2nd route");
        this.context.getRouteController().stopRoute("bar");
        boolean removed = this.context.removeRoute("bar");
        Assertions.assertTrue((boolean)removed);
        names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)16, (int)names.size());
        namesP = mbeanServer.queryNames(onP, null);
        Assertions.assertEquals((int)1, (int)namesP.size());
        this.log.info("Shutting down...");
    }

    @Test
    public void testRouteAddRemoteRouteWithRoutingSlip() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        result.assertIsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("services", "*");
        Set<ObjectName> names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)16, (int)names.size());
        ObjectName onP = this.getCamelObjectName("producers", "*");
        Set<ObjectName> namesP = mbeanServer.queryNames(onP, null);
        Assertions.assertEquals((int)1, (int)namesP.size());
        this.log.info("Adding 2nd route");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:bar").routeId("bar").routingSlip((Expression)this.header("bar"));
            }
        });
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:bar", (Object)"Hello World", "bar", (Object)"mock:bar");
        bar.assertIsSatisfied();
        names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)16, (int)names.size());
        namesP = mbeanServer.queryNames(onP, null);
        Assertions.assertEquals((int)1, (int)namesP.size());
        this.log.info("Removing 2nd route");
        this.context.getRouteController().stopRoute("bar");
        boolean removed = this.context.removeRoute("bar");
        Assertions.assertTrue((boolean)removed);
        names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)16, (int)names.size());
        namesP = mbeanServer.queryNames(onP, null);
        Assertions.assertEquals((int)1, (int)namesP.size());
        this.log.info("Shutting down...");
    }

    @Test
    public void testRouteAddRemoteRouteWithRecipientListAndRouteScopedOnException() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        result.assertIsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("services", "*");
        Set<ObjectName> names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)16, (int)names.size());
        this.log.info("Adding 2nd route");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.from("direct:bar").routeId("bar").onException(Exception.class).handled(true).recipientList((Expression)this.header("error")).end()).end().recipientList((Expression)this.header("bar")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        });
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("error", "mock:error");
        headers.put("bar", "mock:bar");
        this.template.sendBodyAndHeaders("direct:bar", (Object)"Hello World", headers);
        this.assertMockEndpointsSatisfied();
        names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)16, (int)names.size());
        this.log.info("Stopping 2nd route");
        this.context.getRouteController().stopRoute("bar");
        this.log.info("Removing 2nd route");
        boolean removed = this.context.removeRoute("bar");
        Assertions.assertTrue((boolean)removed);
        names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)16, (int)names.size());
        this.log.info("Shutting down...");
    }

    @Test
    public void testRouteAddRemoteRouteWithRecipientListAndContextScopedOnException() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        result.assertIsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("services", "*");
        Set<ObjectName> names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)16, (int)names.size());
        this.log.info("Adding 2nd route");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).handled(true).recipientList((Expression)this.header("error")).end();
                this.from("direct:bar").routeId("bar").recipientList((Expression)this.header("bar")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        });
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("error", "mock:error");
        headers.put("bar", "mock:bar");
        this.template.sendBodyAndHeaders("direct:bar", (Object)"Hello World", headers);
        this.assertMockEndpointsSatisfied();
        names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)16, (int)names.size());
        this.log.info("Stopping 2nd route");
        this.context.getRouteController().stopRoute("bar");
        this.log.info("Removing 2nd route");
        boolean removed = this.context.removeRoute("bar");
        Assertions.assertTrue((boolean)removed);
        names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)16, (int)names.size());
        this.log.info("Shutting down...");
    }

    @Test
    public void testRouteAddRemoteRouteWithRecipientListAndRouteScopedOnCompletion() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        result.assertIsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("services", "*");
        Set<ObjectName> names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)16, (int)names.size());
        this.log.info("Adding 2nd route");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((OnCompletionDefinition)this.from("direct:bar").routeId("bar").onCompletion().recipientList((Expression)this.header("done")).end()).end().recipientList((Expression)this.header("bar"));
            }
        });
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:done").expectedMessageCount(1);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("done", "mock:done");
        headers.put("bar", "mock:bar");
        this.template.sendBodyAndHeaders("direct:bar", (Object)"Hello World", headers);
        this.assertMockEndpointsSatisfied();
        names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)16, (int)names.size());
        this.log.info("Stopping 2nd route");
        this.context.getRouteController().stopRoute("bar");
        this.log.info("Removing 2nd route");
        boolean removed = this.context.removeRoute("bar");
        Assertions.assertTrue((boolean)removed);
        names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)16, (int)names.size());
        this.log.info("Shutting down...");
    }

    @Test
    public void testRouteAddRemoteRouteWithRecipientListAndContextScopedOnCompletion() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        result.assertIsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("services", "*");
        Set<ObjectName> names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)16, (int)names.size());
        this.log.info("Adding 2nd route");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onCompletion().recipientList((Expression)this.header("done")).end();
                this.from("direct:bar").routeId("bar").recipientList((Expression)this.header("bar"));
            }
        });
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:done").expectedMessageCount(1);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("done", "mock:done");
        headers.put("bar", "mock:bar");
        this.template.sendBodyAndHeaders("direct:bar", (Object)"Hello World", headers);
        this.assertMockEndpointsSatisfied();
        names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)16, (int)names.size());
        this.log.info("Stopping 2nd route");
        this.context.getRouteController().stopRoute("bar");
        this.log.info("Removing 2nd route");
        boolean removed = this.context.removeRoute("bar");
        Assertions.assertTrue((boolean)removed);
        names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)16, (int)names.size());
        this.log.info("Shutting down...");
    }
}

