/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedLogMBean;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedRouteNodePrefixIdTest
extends ManagementTestSupport {
    @Test
    public void testNodeIdPrefix() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        Assertions.assertEquals((int)4, (int)set.size());
        ManagedProcessorMBean mb = ((ManagedCamelContext)this.context.getCamelContextExtension().getContextPlugin(ManagedCamelContext.class)).getManagedProcessor("aaamyMock");
        Assertions.assertEquals((Object)"aaamyMock", (Object)mb.getProcessorId());
        Assertions.assertEquals((Object)"foo", (Object)mb.getRouteId());
        Assertions.assertEquals((Object)"aaa", (Object)mb.getNodePrefixId());
        mb = ((ManagedCamelContext)this.context.getCamelContextExtension().getContextPlugin(ManagedCamelContext.class)).getManagedProcessor("bbbmyMock");
        Assertions.assertEquals((Object)"bbbmyMock", (Object)mb.getProcessorId());
        Assertions.assertEquals((Object)"bar", (Object)mb.getRouteId());
        Assertions.assertEquals((Object)"bbb", (Object)mb.getNodePrefixId());
        mb = ((ManagedCamelContext)this.context.getCamelContextExtension().getContextPlugin(ManagedCamelContext.class)).getManagedProcessor("aaalog2", ManagedLogMBean.class);
        Assertions.assertEquals((Object)"aaalog2", (Object)mb.getProcessorId());
        Assertions.assertEquals((Object)"foo", (Object)mb.getRouteId());
        Assertions.assertEquals((Object)"aaa", (Object)mb.getNodePrefixId());
        mb = ((ManagedCamelContext)this.context.getCamelContextExtension().getContextPlugin(ManagedCamelContext.class)).getManagedProcessor("bbblog4", ManagedLogMBean.class);
        Assertions.assertEquals((Object)"bbblog4", (Object)mb.getProcessorId());
        Assertions.assertEquals((Object)"bar", (Object)mb.getRouteId());
        Assertions.assertEquals((Object)"bbb", (Object)mb.getNodePrefixId());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:foo").routeId("foo").nodePrefixId("aaa").to("mock:foo")).id("myMock")).log("Hello foo");
                ((RouteDefinition)((RouteDefinition)this.from("direct:bar").nodePrefixId("bbb").routeId("bar").to("mock:bar")).id("myMock")).log("Hello bar");
            }
        };
    }
}

