/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedSuspendableRouteMBean;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedRouteSuspendAndResumeTest
extends ManagementTestSupport {
    @Test
    public void testSuspendAndResume() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteSuspendAndResumeTest.getRouteObjectName(mbeanServer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state, (String)"Should be started");
        mbeanServer.invoke(on, "suspend", null, null);
        state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Suspended.name(), (Object)state, (String)"Should be suspended");
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        mock.setResultWaitTime(250L);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        mock.assertIsNotSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        mbeanServer.invoke(on, "resume", null, null);
        state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state, (String)"Should be started");
        mock.assertIsSatisfied();
        ManagedSuspendableRouteMBean route = (ManagedSuspendableRouteMBean)((ManagedCamelContext)this.context.getCamelContextExtension().getContextPlugin(ManagedCamelContext.class)).getManagedRoute("foo", ManagedSuspendableRouteMBean.class);
        Assertions.assertNotNull((Object)route);
        Assertions.assertEquals((long)2L, (long)route.getExchangesCompleted());
    }

    static ObjectName getRouteObjectName(MBeanServer mbeanServer) throws Exception {
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        Assertions.assertEquals((int)1, (int)set.size());
        return set.iterator().next();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from(ManagedRouteSuspendAndResumeTest.this.fileUri("?initialDelay=0&delay=10")).routeId("foo").to("mock:result");
            }
        };
    }
}

