/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedSedaEndpointTest
extends ManagementTestSupport {
    @Test
    public void testSedaEndpoint() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.template.sendBody("seda:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = this.getCamelObjectName("endpoints", "seda://start");
        String uri = (String)mbeanServer.getAttribute(name, "EndpointUri");
        Assertions.assertEquals((Object)"seda://start", (Object)uri);
        Long timeout = (Long)mbeanServer.getAttribute(name, "Timeout");
        Assertions.assertEquals((int)30000, (int)timeout.intValue());
        Integer size = (Integer)mbeanServer.getAttribute(name, "CurrentQueueSize");
        Assertions.assertEquals((int)0, (int)size);
        Boolean singleton = (Boolean)mbeanServer.getAttribute(name, "Singleton");
        Assertions.assertEquals((Object)true, (Object)singleton);
        this.context.getRouteController().stopRoute("foo");
        this.template.sendBody("seda:start", (Object)"Hi World");
        size = (Integer)mbeanServer.getAttribute(name, "CurrentQueueSize");
        Assertions.assertEquals((int)1, (int)size);
        Long size2 = (Long)mbeanServer.invoke(name, "queueSize", null, null);
        Assertions.assertEquals((long)1L, (long)size2);
        String out = (String)mbeanServer.invoke(name, "browseExchange", new Object[]{0}, new String[]{"java.lang.Integer"});
        Assertions.assertNotNull((Object)out);
        Assertions.assertFalse((boolean)out.contains("Hi World"));
        out = (String)mbeanServer.invoke(name, "browseMessageBody", new Object[]{0}, new String[]{"java.lang.Integer"});
        Assertions.assertNotNull((Object)out);
        Assertions.assertTrue((boolean)out.contains("Hi World"));
        mbeanServer.invoke(name, "purgeQueue", null, null);
        size = (Integer)mbeanServer.getAttribute(name, "CurrentQueueSize");
        Assertions.assertEquals((int)0, (int)size);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:start").routeId("foo").to("log:foo")).to("mock:result");
            }
        };
    }
}

