/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.TestSupport;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class TwoManagedCamelContextTest
extends TestSupport {
    private CamelContext camel1;
    private CamelContext camel2;

    protected CamelContext createCamelContext(String name) throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getCamelContextExtension().setName(name);
        return context;
    }

    @Test
    public void testTwoManagedCamelContext() throws Exception {
        this.camel1 = this.createCamelContext("foo");
        this.camel2 = this.createCamelContext("bar");
        this.camel1.start();
        this.camel2.start();
        MBeanServer mbeanServer = this.camel1.getManagementStrategy().getManagementAgent().getMBeanServer();
        ObjectName on = TwoManagedCamelContextTest.getContextObjectName(this.camel1);
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
        ObjectName on2 = TwoManagedCamelContextTest.getContextObjectName(this.camel2);
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on2), (String)"Should be registered");
        this.camel1.stop();
        this.camel2.stop();
        Assertions.assertFalse((boolean)mbeanServer.isRegistered(on), (String)"Should be unregistered");
        Assertions.assertFalse((boolean)mbeanServer.isRegistered(on2), (String)"Should be unregistered");
    }

    private static ObjectName getContextObjectName(CamelContext context) throws MalformedObjectNameException {
        return ObjectName.getInstance("org.apache.camel:context=" + context.getManagementName() + ",type=context,name=\"" + context.getName() + "\"");
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.camel1 != null) {
            this.camel1.stop();
        }
        if (this.camel2 != null) {
            this.camel2.stop();
        }
        super.tearDown();
    }
}

