/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class AddEventNotifierTest
extends ContextTestSupport {
    private static final List<CamelEvent> events = new ArrayList<CamelEvent>();

    @BeforeEach
    public void setUp() throws Exception {
        events.clear();
        super.setUp();
    }

    @Test
    public void testAddAndRemove() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)0, (int)events.size());
        EventNotifierSupport notifier = new EventNotifierSupport(){

            public void notify(CamelEvent event) {
                events.add(event);
            }
        };
        this.context.addService((Object)notifier);
        this.context.getManagementStrategy().addEventNotifier((EventNotifier)notifier);
        this.resetMocks();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)8, (int)events.size());
        this.context.getManagementStrategy().removeEventNotifier((EventNotifier)notifier);
        this.resetMocks();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hi World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)8, (int)events.size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

