/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.w3c.dom.Document;

@DisabledOnOs(value={OS.AIX})
public class ManagedCamelContextDumpRoutesCoverageAsXmlTest
extends ManagementTestSupport {
    @Test
    public void testRouteCoverageStats() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.asyncSendBody("direct:start", (Object)"Hello World");
        this.template.asyncSendBody("direct:bar", (Object)"Hi World");
        this.template.asyncSendBody("direct:bar", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        String xml = (String)mbeanServer.invoke(on, "dumpRoutesCoverageAsXml", null, null);
        this.log.info(xml);
        Assertions.assertTrue((boolean)xml.contains("exchangesTotal=\"3\""));
        Assertions.assertTrue((boolean)xml.contains("exchangesTotal=\"2\""));
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)xml);
        Assertions.assertNotNull((Object)doc);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").routeId("foo").to("log:foo")).delay(100L).to("mock:foo");
                ((RouteDefinition)this.from("direct:bar").routeId("bar").to("log:bar")).to("mock:bar");
            }
        };
    }
}

