/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedCanekContextExchangeStatisticsTest
extends ManagementTestSupport {
    @Test
    public void testExchangesCompletedStatistics() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        Assertions.assertEquals((long)0L, (long)completed);
        ObjectName route1 = this.getCamelObjectName("routes", "route1");
        Long completed1 = (Long)mbeanServer.getAttribute(route1, "ExchangesCompleted");
        Assertions.assertEquals((long)0L, (long)completed1);
        ObjectName route2 = this.getCamelObjectName("routes", "route2");
        Long completed2 = (Long)mbeanServer.getAttribute(route1, "ExchangesCompleted");
        Assertions.assertEquals((long)0L, (long)completed2);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        completed = (Long)mbeanServer.getAttribute(route1, "ExchangesCompleted");
        Assertions.assertEquals((long)1L, (long)completed);
        completed1 = (Long)mbeanServer.getAttribute(route1, "ExchangesCompleted");
        Assertions.assertEquals((long)1L, (long)completed1);
        completed2 = (Long)mbeanServer.getAttribute(route2, "ExchangesCompleted");
        Assertions.assertEquals((long)0L, (long)completed2);
        this.resetMocks();
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hi World");
        this.template.sendBody("direct:bar", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        Assertions.assertEquals((long)3L, (long)completed);
        completed1 = (Long)mbeanServer.getAttribute(route1, "ExchangesCompleted");
        Assertions.assertEquals((long)2L, (long)completed1);
        completed2 = (Long)mbeanServer.getAttribute(route2, "ExchangesCompleted");
        Assertions.assertEquals((long)1L, (long)completed2);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").routeId("route1").to("log:foo")).to("mock:result");
                ((RouteDefinition)this.from("direct:bar").routeId("route2").to("log:bar")).to("mock:result");
            }
        };
    }
}

