/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.ManagementMBeansLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public abstract class ManagedMBeansLevelTestSupport
extends ManagementTestSupport {
    private final ManagementMBeansLevel level;

    public ManagedMBeansLevelTestSupport(ManagementMBeansLevel level) {
        this.level = level;
    }

    abstract void assertResults(Set<ObjectName> var1, Set<ObjectName> var2, Set<ObjectName> var3);

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        if (this.level != null) {
            context.getManagementStrategy().getManagementAgent().setMBeansLevel(this.level);
        }
        return context;
    }

    @Test
    public void test() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        this.assertMBeans(mbeanServer);
    }

    void assertMBeans(MBeanServer mbeanServer) throws MalformedObjectNameException {
        Set<ObjectName> contexts = mbeanServer.queryNames(new ObjectName("*:type=context,*"), null);
        Set<ObjectName> routes = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        Set<ObjectName> processors = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        this.assertResults(contexts, routes, processors);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

