/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedRedeliverTest
extends ManagementTestSupport {
    @Test
    public void testRedeliver() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        MockEndpoint mock = this.getMockEndpoint("mock:foo");
        mock.expectedMessageCount(1);
        Object out = this.template.requestBody("direct:start", (Object)"Hello World");
        Assertions.assertEquals((Object)"Error", (Object)out);
        this.assertMockEndpointsSatisfied();
        ObjectName on = this.getCamelObjectName("routes", "route1");
        Long num = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        Assertions.assertEquals((long)1L, (long)num);
        num = (Long)mbeanServer.getAttribute(on, "ExchangesFailed");
        Assertions.assertEquals((long)0L, (long)num);
        num = (Long)mbeanServer.getAttribute(on, "FailuresHandled");
        Assertions.assertEquals((long)1L, (long)num);
        on = this.getCamelObjectName("processors", "myprocessor");
        num = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        Assertions.assertEquals((long)0L, (long)num);
        num = (Long)mbeanServer.getAttribute(on, "ExchangesTotal");
        Assertions.assertEquals((long)5L, (long)num);
        num = (Long)mbeanServer.getAttribute(on, "ExchangesFailed");
        Assertions.assertEquals((long)5L, (long)num);
        num = (Long)mbeanServer.getAttribute(on, "Redeliveries");
        Assertions.assertEquals((long)4L, (long)num);
        String first = (String)mbeanServer.getAttribute(on, "FirstExchangeFailureExchangeId");
        Assertions.assertEquals((Object)((Exchange)mock.getReceivedExchanges().get(0)).getExchangeId(), (Object)first);
        String last = (String)mbeanServer.getAttribute(on, "LastExchangeFailureExchangeId");
        Assertions.assertEquals((Object)((Exchange)mock.getReceivedExchanges().get(0)).getExchangeId(), (Object)last);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(Exception.class).handled(true).redeliveryDelay(0L).maximumRedeliveries(4).logStackTrace(false).setBody().constant((Object)"Error");
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:foo")).process(exchange -> {
                    this.log.info("Invoking me");
                    throw new IllegalArgumentException("Damn");
                })).id("myprocessor");
            }
        };
    }
}

