/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedRegisterExchangeStatisticsTest
extends ManagementTestSupport {
    @Test
    public void testExchangesCompletedStatistics() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("routes", ((Route)this.context.getRoutes().get(0)).getRouteId());
        Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        Assertions.assertEquals((long)0L, (long)completed);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        Assertions.assertEquals((long)1L, (long)completed);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

