/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedRouteDirectWhileIssueLeakTest
extends ManagementTestSupport {
    @Test
    public void testInflightLeak() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"AAAA"});
        this.template.sendBodyAndHeader("direct:start", (Object)"", "counter", (Object)4);
        this.assertMockEndpointsSatisfied();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        Assertions.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        Long inflight = (Long)mbeanServer.getAttribute(on, "ExchangesInflight");
        Assertions.assertEquals((long)0L, (long)inflight);
        Long ts = (Long)mbeanServer.getAttribute(on, "OldestInflightDuration");
        Assertions.assertNull((Object)ts);
        String id = (String)mbeanServer.getAttribute(on, "OldestInflightExchangeId");
        Assertions.assertNull((Object)id);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when((Predicate)this.simple("${header.counter} > 0")).process(exchange -> {
                    Object body = (String)exchange.getIn().getBody(String.class);
                    body = "A" + (String)body;
                    exchange.getIn().setBody(body);
                    int counter = (Integer)exchange.getIn().getHeader("counter", Integer.TYPE);
                    exchange.getIn().setHeader("counter", (Object)(--counter));
                })).to("direct:start")).otherwise().to("mock:result")).end();
            }
        };
    }
}

