/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedRouteStopAndStartTest
extends ManagementTestSupport {
    @Test
    public void testStopAndStartRoute() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteStopAndStartTest.getRouteObjectName(mbeanServer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state, (String)"Should be started");
        String id = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertEquals((Object)"foo", (Object)id);
        String description = (String)mbeanServer.getAttribute(on, "Description");
        Assertions.assertEquals((Object)"This is the foo route", (Object)description);
        mbeanServer.invoke(on, "stop", null, null);
        state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Stopped.name(), (Object)state, (String)"Should be stopped");
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        mock.setResultWaitTime(100L);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        mock.assertIsNotSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        mbeanServer.invoke(on, "start", null, null);
        state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state, (String)"Should be started");
        mock.assertIsSatisfied();
    }

    static ObjectName getRouteObjectName(MBeanServer mbeanServer) throws Exception {
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        Assertions.assertEquals((int)1, (int)set.size());
        return set.iterator().next();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(ManagedRouteStopAndStartTest.this.fileUri("?initialDelay=0&delay=10")).routeId("foo").routeDescription("This is the foo route").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

