/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedTypeConverterRegistryTest
extends ManagementTestSupport {
    @Test
    public void testTypeConverterRegistry() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"3");
        this.template.sendBody("direct:start", (Object)"7");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("services", "*");
        Set<ObjectName> names = mbeanServer.queryNames(on, null);
        ObjectName name = null;
        for (ObjectName service : names) {
            if (!service.toString().contains("DefaultTypeConverter")) continue;
            name = service;
            break;
        }
        Assertions.assertNotNull(name, (String)"Cannot find DefaultTypeConverter");
        Boolean enabled = (Boolean)mbeanServer.getAttribute(name, "StatisticsEnabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled);
        mbeanServer.setAttribute(name, new Attribute("StatisticsEnabled", Boolean.TRUE));
        Long failed = (Long)mbeanServer.getAttribute(name, "FailedCounter");
        Assertions.assertEquals((int)0, (int)failed.intValue());
        Long miss = (Long)mbeanServer.getAttribute(name, "MissCounter");
        Assertions.assertEquals((int)0, (int)miss.intValue());
        mbeanServer.invoke(name, "resetTypeConversionCounters", null, null);
        this.template.sendBody("direct:start", (Object)"5");
        Long hit = (Long)mbeanServer.getAttribute(name, "HitCounter");
        Assertions.assertEquals((int)1, (int)hit.intValue());
        failed = (Long)mbeanServer.getAttribute(name, "FailedCounter");
        Assertions.assertEquals((int)0, (int)failed.intValue());
        miss = (Long)mbeanServer.getAttribute(name, "MissCounter");
        Assertions.assertEquals((int)2, (int)miss.intValue());
        mbeanServer.invoke(name, "resetTypeConversionCounters", null, null);
        try {
            this.template.sendBody("direct:start", (Object)"foo");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        failed = (Long)mbeanServer.getAttribute(name, "FailedCounter");
        Assertions.assertEquals((int)1, (int)failed.intValue());
        miss = (Long)mbeanServer.getAttribute(name, "MissCounter");
        Assertions.assertEquals((int)1, (int)miss.intValue());
        mbeanServer.invoke(name, "resetTypeConversionCounters", null, null);
        failed = (Long)mbeanServer.getAttribute(name, "FailedCounter");
        Assertions.assertEquals((int)0, (int)failed.intValue());
        miss = (Long)mbeanServer.getAttribute(name, "MissCounter");
        Assertions.assertEquals((int)0, (int)miss.intValue());
        Integer converters = (Integer)mbeanServer.getAttribute(name, "NumberOfTypeConverters");
        Assertions.assertTrue((converters >= 150 ? 1 : 0) != 0, (String)("Should be more than 150 converters, was: " + converters));
        Boolean has = (Boolean)mbeanServer.invoke(name, "hasTypeConverter", new Object[]{"java.lang.String", "java.io.InputStream"}, new String[]{"java.lang.String", "java.lang.String"});
        Assertions.assertTrue((boolean)has, (String)"Should have type converter");
        has = (Boolean)mbeanServer.invoke(name, "hasTypeConverter", new Object[]{"java.math.BigInteger", "int"}, new String[]{"java.lang.String", "java.lang.String"});
        Assertions.assertTrue((boolean)has, (String)"Should have type converter");
        has = (Boolean)mbeanServer.invoke(name, "hasTypeConverter", new Object[]{"java.math.BigInteger", "java.util.Random"}, new String[]{"java.lang.String", "java.lang.String"});
        Assertions.assertFalse((boolean)has, (String)"Should not have type converter");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").routeId("foo").convertBodyTo(Integer.TYPE)).to("mock:a");
            }
        };
    }
}

