/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.Predicate;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedChoiceTest
extends ManagementTestSupport {
    @Test
    public void testManageChoice() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "foo", (Object)"456");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hi World", "bar", (Object)"789");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("processors", "mysend");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertEquals((Object)"route1", (Object)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)this.context.getManagementName(), (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        int level = (Integer)mbeanServer.getAttribute(on, "Level");
        Assertions.assertEquals((int)1, (int)level);
        TabularData data = (TabularData)mbeanServer.invoke(on, "extendedInformation", null, null);
        Assertions.assertNotNull((Object)data);
        Assertions.assertEquals((int)2, (int)data.size());
        on = this.getCamelObjectName("processors", "bar");
        level = (Integer)mbeanServer.getAttribute(on, "Level");
        Assertions.assertEquals((int)2, (int)level);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().id("mysend")).when((Predicate)this.header("foo")).to("mock:foo")).otherwise().to("mock:bar")).id("bar");
            }
        };
    }
}

