/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.IOException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.CamelContext;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.TryDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedDoTryCatchFinallyTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementStrategy().getManagementAgent().setStatisticsLevel(ManagementStatisticsLevel.Extended);
        return context;
    }

    @Test
    public void testManageTryCatchFinally() throws Exception {
        this.getMockEndpoint("mock:start").expectedMessageCount(1);
        this.getMockEndpoint("mock:finally").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("processors", "myDoCatch2");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertEquals((Object)"route1", (Object)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)this.context.getManagementName(), (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        Long count = (Long)mbeanServer.getAttribute(on, "CaughtCount");
        Assertions.assertEquals((long)1L, (long)count);
        on = this.getCamelObjectName("processors", "myDoCatch1");
        count = (Long)mbeanServer.getAttribute(on, "CaughtCount");
        Assertions.assertEquals((long)0L, (long)count);
        on = this.getCamelObjectName("processors", "myDoTry1");
        TabularData data = (TabularData)mbeanServer.invoke(on, "extendedInformation", null, null);
        Assertions.assertNotNull((Object)data);
        Assertions.assertEquals((int)1, (int)data.size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().id("myDoTry1")).to("mock:start")).throwException((Exception)new IllegalArgumentException("Forced"))).doCatch(IOException.class).id("myDoCatch1")).to("mock:io")).doCatch(IllegalArgumentException.class).id("myDoCatch2")).to("mock:iae")).doFinally().to("mock:finally")).end();
            }
        };
    }
}

