/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Arrays;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.rest.CollectionFormat;
import org.apache.camel.model.rest.RestParamType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedFromRestPlaceholderTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext answer = super.createCamelContext();
        answer.getRegistry().bind("dummy-test", (Object)new DummyRestConsumerFactory());
        answer.getPropertiesComponent().setLocation("classpath:org/apache/camel/management/rest.properties");
        return answer;
    }

    @Test
    public void testFromRestModelPlaceholder() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        String xml = (String)mbeanServer.invoke(on, "dumpRestsAsXml", new Object[]{true}, new String[]{"boolean"});
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Assertions.assertTrue((boolean)xml.contains("<rests"));
        Assertions.assertTrue((boolean)xml.contains("<rest path=\"/say/hello\">"));
        Assertions.assertTrue((boolean)xml.contains("<rest path=\"/say/bye\">"));
        Assertions.assertTrue((boolean)xml.contains("</rest>"));
        Assertions.assertTrue((boolean)xml.contains("<get"));
        Assertions.assertTrue((boolean)xml.contains("application/json"));
        Assertions.assertTrue((boolean)xml.contains("<post"));
        Assertions.assertTrue((boolean)xml.contains("application/json"));
        Assertions.assertTrue((boolean)xml.contains("</rests>"));
        Assertions.assertTrue((boolean)xml.contains("<param defaultValue=\"1\" dataType=\"integer\" name=\"header_count\" description=\"header param description1\" type=\"header\" required=\"true\""));
        Assertions.assertTrue((boolean)xml.contains("<param defaultValue=\"b\" dataType=\"string\" name=\"header_letter\" description=\"header param description2\" type=\"query\" collectionFormat=\"multi\" required=\"false\""));
        Assertions.assertTrue((boolean)xml.contains("<value>1</value>"));
        Assertions.assertTrue((boolean)xml.contains("<value>a</value>"));
        Assertions.assertTrue((boolean)xml.contains("<responseMessage code=\"300\" responseModel=\"java.lang.Integer\" message=\"test msg\"/>"));
        String xml2 = (String)mbeanServer.invoke(on, "dumpRoutesAsXml", null, null);
        this.log.info(xml2);
        Assertions.assertTrue((boolean)xml2.contains("rest=\"true\""));
        Assertions.assertEquals((int)3, (int)this.context.getRouteDefinitions().size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.restConfiguration().host("localhost");
                this.rest("{{foo}}").get().to("direct:hello");
                this.rest("{{bar}}").get().consumes("application/json").param().type(RestParamType.header).description("header param description1").dataType("integer").allowableValues(Arrays.asList("1", "2", "3", "4")).defaultValue("1").name("header_count").required(Boolean.valueOf(true)).endParam().param().type(RestParamType.query).description("header param description2").dataType("string").allowableValues(Arrays.asList("a", "b", "c", "d")).defaultValue("b").collectionFormat(CollectionFormat.multi).name("header_letter").required(Boolean.valueOf(false)).endParam().responseMessage().code(300).message("test msg").responseModel(Integer.class).endResponseMessage().to("direct:bye").post().to("mock:update");
                this.from("direct:hello").transform().constant((Object)"Hello World");
                this.from("direct:bye").transform().constant((Object)"Bye World");
            }
        };
    }
}

