/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedRegisterTwoRoutesTest
extends ManagementTestSupport {
    @Test
    public void testRoutes() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        Assertions.assertEquals((int)2, (int)set.size());
        HashSet<String> uris = new HashSet<String>();
        for (ObjectName on : set) {
            String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
            uris.add(uri);
        }
        Assertions.assertTrue((boolean)uris.contains("direct://start"));
        Assertions.assertTrue((boolean)uris.contains("direct://foo"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
                this.from("direct:foo").to("mock:foo");
            }
        };
    }
}

