/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedShutdownStrategyTest
extends ManagementTestSupport {
    @Test
    public void testManagedShutdownStrategy() throws Exception {
        this.context.getShutdownStrategy().setTimeout(300L);
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("services", "*");
        Set<ObjectName> names = mbeanServer.queryNames(on, null);
        ObjectName name = null;
        for (ObjectName service : names) {
            if (!service.toString().contains("DefaultShutdownStrategy")) continue;
            name = service;
            break;
        }
        Assertions.assertNotNull(name, (String)"Cannot find DefaultShutdownStrategy");
        Long timeout = (Long)mbeanServer.getAttribute(name, "Timeout");
        Assertions.assertEquals((long)300L, (long)timeout);
        TimeUnit unit = (TimeUnit)((Object)mbeanServer.getAttribute(name, "TimeUnit"));
        Assertions.assertEquals((Object)"seconds", (Object)unit.toString().toLowerCase(Locale.ENGLISH));
        String level = (String)mbeanServer.getAttribute(name, "LoggingLevel");
        Assertions.assertEquals((Object)"DEBUG", (Object)level);
        Boolean order = (Boolean)mbeanServer.getAttribute(name, "ShutdownRoutesInReverseOrder");
        Assertions.assertTrue((boolean)order);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:foo").to("mock:foo");
            }
        };
    }
}

