/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedSplitterTest
extends ManagementTestSupport {
    @Test
    public void testManageSplitter() throws Exception {
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello,World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("processors", "mysend");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertEquals((Object)"route1", (Object)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)this.context.getManagementName(), (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        String lan = (String)mbeanServer.getAttribute(on, "Expression");
        Assertions.assertEquals((Object)"${body}", (Object)lan);
        String exp = (String)mbeanServer.getAttribute(on, "Expression");
        Assertions.assertEquals((Object)"${body}", (Object)exp);
        String xml = (String)mbeanServer.invoke(on, "dumpProcessorAsXml", null, null);
        Assertions.assertTrue((boolean)xml.contains("<split"));
        Assertions.assertTrue((boolean)xml.contains("</split>"));
        Assertions.assertTrue((boolean)xml.contains("<simple>${body}</simple>"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").split((Expression)this.simple("${body}")).id("mysend").to("mock:foo");
            }
        };
    }
}

