/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.InputStream;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.FileUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedStreamCachingStrategyTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext camelContext = super.createCamelContext();
        camelContext.getStreamCachingStrategy().setAllowClasses(new Class[]{InputStream.class});
        return camelContext;
    }

    @Test
    public void testStreamCachingStrategy() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        Assertions.assertEquals((Object)"myCamel", (Object)this.context.getManagementName());
        ObjectName on = this.getCamelObjectName("services", "*");
        Set<ObjectName> names = mbeanServer.queryNames(on, null);
        ObjectName name = null;
        for (ObjectName service : names) {
            if (!service.toString().contains("DefaultStreamCachingStrategy")) continue;
            name = service;
            break;
        }
        Assertions.assertNotNull(name, (String)"Cannot find DefaultStreamCachingStrategy");
        Boolean enabled = (Boolean)mbeanServer.getAttribute(name, "Enabled");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)enabled);
        enabled = (Boolean)mbeanServer.getAttribute(name, "SpoolEnabled");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)enabled);
        String dir = (String)mbeanServer.getAttribute(name, "SpoolDirectory");
        Assertions.assertEquals((Object)FileUtil.normalizePath((String)this.testDirectory("myCamel").toString()), (Object)FileUtil.normalizePath((String)dir));
        Long threshold = (Long)mbeanServer.getAttribute(name, "SpoolThreshold");
        Assertions.assertEquals((long)131072L, (long)threshold);
        Integer size = (Integer)mbeanServer.getAttribute(name, "BufferSize");
        Assertions.assertEquals((int)16384, (int)size);
        Long counter = (Long)mbeanServer.getAttribute(name, "CacheMemoryCounter");
        Assertions.assertEquals((long)0L, (long)counter);
        counter = (Long)mbeanServer.getAttribute(name, "CacheSpoolCounter");
        Assertions.assertEquals((long)0L, (long)counter);
        Long cacheSize = (Long)mbeanServer.getAttribute(name, "CacheMemorySize");
        Assertions.assertEquals((long)0L, (long)cacheSize);
        cacheSize = (Long)mbeanServer.getAttribute(name, "CacheSpoolSize");
        Assertions.assertEquals((long)0L, (long)cacheSize);
        String cipher = (String)mbeanServer.getAttribute(name, "SpoolCipher");
        Assertions.assertNull((Object)cipher);
        Boolean remove = (Boolean)mbeanServer.getAttribute(name, "RemoveSpoolDirectoryWhenStopping");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)remove);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                DefaultCamelContext dcc = (DefaultCamelContext)ManagedStreamCachingStrategyTest.this.context;
                dcc.getCamelContextExtension().setName("myCamel");
                ManagedStreamCachingStrategyTest.this.context.setStreamCaching(Boolean.valueOf(true));
                ManagedStreamCachingStrategyTest.this.context.getStreamCachingStrategy().setSpoolEnabled(true);
                ManagedStreamCachingStrategyTest.this.context.getStreamCachingStrategy().setSpoolDirectory(ManagedStreamCachingStrategyTest.this.testDirectory("#name#").toString());
                ((RouteDefinition)this.from("direct:start").routeId("foo").convertBodyTo(Integer.TYPE)).to("mock:a");
            }
        };
    }
}

