/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class ReduceStacksNeededDuringRoutingTest
extends ContextTestSupport {
    protected boolean useJmx() {
        return true;
    }

    @Test
    public void testReduceStacksNeeded() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:start").to("log:foo")).to("log:bar")).to("log:baz")).process(exchange -> {
                    try {
                        throw new IllegalArgumentException("Forced to dump stacktrace");
                    }
                    catch (Exception e) {
                        e.fillInStackTrace();
                        this.log.info("There are {} lines in the stacktrace", (Object)e.getStackTrace().length);
                        this.log.error("Dump stacktrace to log", (Throwable)e);
                        return;
                    }
                })).to("mock:result");
            }
        };
    }
}

