/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.NamedNode;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Route;
import org.apache.camel.TimerListener;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedCamelContextMBean;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.api.management.mbean.ManagedStepMBean;
import org.apache.camel.management.mbean.LoadThroughput;
import org.apache.camel.management.mbean.LoadTriplet;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.management.mbean.RouteCoverageXmlParser;
import org.apache.camel.management.mbean.Statistic;
import org.apache.camel.management.mbean.StatisticCounter;
import org.apache.camel.model.Model;
import org.apache.camel.model.RouteTemplatesDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PluginHelper;
import org.w3c.dom.Document;

@ManagedResource(description="Managed CamelContext")
public class ManagedCamelContext
extends ManagedPerformanceCounter
implements TimerListener,
ManagedCamelContextMBean {
    private final CamelContext context;
    private final LoadTriplet load = new LoadTriplet();
    private final LoadThroughput thp = new LoadThroughput();
    private final String jmxDomain;
    private final boolean includeRouteTemplates;
    private final boolean includeKamelets;
    private Statistic remoteExchangesTotal;
    private Statistic remoteExchangesCompleted;
    private Statistic remoteExchangesFailed;
    private Statistic remoteExchangesInflight;

    public ManagedCamelContext(CamelContext context) {
        this.context = context;
        this.jmxDomain = context.getManagementStrategy().getManagementAgent().getMBeanObjectDomainName();
        this.includeRouteTemplates = context.getManagementStrategy().getManagementAgent().getRegisterRoutesCreateByTemplate();
        this.includeKamelets = context.getManagementStrategy().getManagementAgent().getRegisterRoutesCreateByKamelet();
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        this.remoteExchangesTotal = new StatisticCounter();
        this.remoteExchangesCompleted = new StatisticCounter();
        this.remoteExchangesFailed = new StatisticCounter();
        this.remoteExchangesInflight = new StatisticCounter();
        boolean enabled = this.context.getManagementStrategy().getManagementAgent() != null && this.context.getManagementStrategy().getManagementAgent().getStatisticsLevel() != ManagementStatisticsLevel.Off;
        this.setStatisticsEnabled(enabled);
    }

    @Override
    public void reset() {
        super.reset();
        this.remoteExchangesTotal.reset();
        this.remoteExchangesCompleted.reset();
        this.remoteExchangesFailed.reset();
        this.remoteExchangesInflight.reset();
    }

    @Override
    public void completedExchange(Exchange exchange, long time) {
        UnitOfWork uow = exchange.getUnitOfWork();
        if (uow != null) {
            int level = uow.routeStackLevel(this.includeRouteTemplates, this.includeKamelets);
            if (level <= 1) {
                super.completedExchange(exchange, time);
                if (exchange.getFromEndpoint() != null && exchange.getFromEndpoint().isRemote()) {
                    this.remoteExchangesTotal.increment();
                    this.remoteExchangesCompleted.increment();
                    this.remoteExchangesInflight.decrement();
                }
            }
        } else {
            super.completedExchange(exchange, time);
            if (exchange.getFromEndpoint() != null && exchange.getFromEndpoint().isRemote()) {
                this.remoteExchangesTotal.increment();
                this.remoteExchangesCompleted.increment();
                this.remoteExchangesInflight.decrement();
            }
        }
    }

    @Override
    public void failedExchange(Exchange exchange) {
        UnitOfWork uow = exchange.getUnitOfWork();
        if (uow != null) {
            int level = uow.routeStackLevel(this.includeRouteTemplates, this.includeKamelets);
            if (level <= 1) {
                super.failedExchange(exchange);
                if (exchange.getFromEndpoint() != null && exchange.getFromEndpoint().isRemote()) {
                    this.remoteExchangesTotal.increment();
                    this.remoteExchangesFailed.increment();
                    this.remoteExchangesInflight.decrement();
                }
            }
        } else {
            super.failedExchange(exchange);
            if (exchange.getFromEndpoint() != null && exchange.getFromEndpoint().isRemote()) {
                this.remoteExchangesTotal.increment();
                this.remoteExchangesFailed.increment();
                this.remoteExchangesInflight.decrement();
            }
        }
    }

    @Override
    public void processExchange(Exchange exchange, String type) {
        UnitOfWork uow = exchange.getUnitOfWork();
        if (uow != null) {
            int level = uow.routeStackLevel(this.includeRouteTemplates, this.includeKamelets);
            if (level <= 1) {
                super.processExchange(exchange, type);
                if (exchange.getFromEndpoint() != null && exchange.getFromEndpoint().isRemote()) {
                    this.remoteExchangesInflight.increment();
                }
            }
        } else {
            super.processExchange(exchange, type);
            if (exchange.getFromEndpoint() != null && exchange.getFromEndpoint().isRemote()) {
                this.remoteExchangesInflight.increment();
            }
        }
    }

    public CamelContext getContext() {
        return this.context;
    }

    public String getCamelId() {
        return this.context.getName();
    }

    public String getCamelDescription() {
        return this.context.getDescription();
    }

    public String getManagementName() {
        return this.context.getManagementName();
    }

    public String getCamelVersion() {
        return this.context.getVersion();
    }

    public String getProfile() {
        return this.context.getCamelContextExtension().getProfile();
    }

    public String getState() {
        return this.context.getStatus().name();
    }

    public String getUptime() {
        return CamelContextHelper.getUptime((CamelContext)this.context);
    }

    public long getUptimeMillis() {
        return this.context.getUptime().toMillis();
    }

    public String getManagementStatisticsLevel() {
        if (this.context.getManagementStrategy().getManagementAgent() != null) {
            return this.context.getManagementStrategy().getManagementAgent().getStatisticsLevel().name();
        }
        return null;
    }

    public String getClassResolver() {
        return this.context.getClassResolver().getClass().getName();
    }

    public String getPackageScanClassResolver() {
        return PluginHelper.getPackageScanClassResolver((CamelContext)this.context).getClass().getName();
    }

    public String getApplicationContextClassName() {
        if (this.context.getApplicationContextClassLoader() != null) {
            return this.context.getApplicationContextClassLoader().getClass().getName();
        }
        return null;
    }

    public String getHeadersMapFactoryClassName() {
        return this.context.getCamelContextExtension().getHeadersMapFactory().getClass().getName();
    }

    public Map<String, String> getGlobalOptions() {
        if (this.context.getGlobalOptions().isEmpty()) {
            return null;
        }
        return this.context.getGlobalOptions();
    }

    public String getGlobalOption(String key) throws Exception {
        return this.context.getGlobalOption(key);
    }

    public void setGlobalOption(String key, String value) throws Exception {
        this.context.getGlobalOptions().put(key, value);
    }

    public Boolean getTracing() {
        return this.context.isTracing();
    }

    public void setTracing(Boolean tracing) {
        this.context.setTracing(tracing);
    }

    public Integer getInflightExchanges() {
        return (int)super.getExchangesInflight();
    }

    public Integer getTotalRoutes() {
        return this.context.getRoutesSize();
    }

    public Integer getStartedRoutes() {
        int started = 0;
        for (Route route : this.context.getRoutes()) {
            if (!this.context.getRouteController().getRouteStatus(route.getId()).isStarted()) continue;
            ++started;
        }
        return started;
    }

    public void setTimeout(long timeout) {
        this.context.getShutdownStrategy().setTimeout(timeout);
    }

    public long getTimeout() {
        return this.context.getShutdownStrategy().getTimeout();
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.context.getShutdownStrategy().setTimeUnit(timeUnit);
    }

    public TimeUnit getTimeUnit() {
        return this.context.getShutdownStrategy().getTimeUnit();
    }

    public void setShutdownNowOnTimeout(boolean shutdownNowOnTimeout) {
        this.context.getShutdownStrategy().setShutdownNowOnTimeout(shutdownNowOnTimeout);
    }

    public boolean isShutdownNowOnTimeout() {
        return this.context.getShutdownStrategy().isShutdownNowOnTimeout();
    }

    public String getLoad01() {
        double load1 = this.load.getLoad1();
        if (Double.isNaN(load1)) {
            return "";
        }
        return String.format("%.2f", load1);
    }

    public String getLoad05() {
        double load5 = this.load.getLoad5();
        if (Double.isNaN(load5)) {
            return "";
        }
        return String.format("%.2f", load5);
    }

    public String getLoad15() {
        double load15 = this.load.getLoad15();
        if (Double.isNaN(load15)) {
            return "";
        }
        return String.format("%.2f", load15);
    }

    public String getThroughput() {
        double d = this.thp.getThroughput();
        if (Double.isNaN(d)) {
            return "";
        }
        return String.format("%.2f", d);
    }

    public long getRemoteExchangesTotal() {
        return this.remoteExchangesTotal.getValue();
    }

    public long getRemoteExchangesCompleted() {
        return this.remoteExchangesCompleted.getValue();
    }

    public long getRemoteExchangesFailed() {
        return this.remoteExchangesFailed.getValue();
    }

    public long getRemoteExchangesInflight() {
        return this.remoteExchangesInflight.getValue();
    }

    public boolean isUseBreadcrumb() {
        return this.context.isUseBreadcrumb();
    }

    public boolean isAllowUseOriginalMessage() {
        return this.context.isAllowUseOriginalMessage();
    }

    public boolean isMessageHistory() {
        return this.context.isMessageHistory() != null ? this.context.isMessageHistory() : false;
    }

    public boolean isLogMask() {
        return this.context.isLogMask() != null ? this.context.isLogMask() : false;
    }

    public boolean isUseMDCLogging() {
        return this.context.isUseMDCLogging();
    }

    public boolean isUseDataType() {
        return this.context.isUseDataType();
    }

    public void onTimer() {
        this.load.update(this.getInflightExchanges());
        this.thp.update(this.getExchangesTotal());
    }

    public void start() throws Exception {
        if (this.context.isSuspended()) {
            this.context.resume();
        } else {
            this.context.start();
        }
    }

    public void stop() throws Exception {
        this.context.stop();
    }

    public void restart() throws Exception {
        this.context.stop();
        this.context.start();
    }

    public void suspend() throws Exception {
        this.context.suspend();
    }

    public void resume() throws Exception {
        if (!this.context.isSuspended()) {
            throw new IllegalStateException("CamelContext is not suspended");
        }
        this.context.resume();
    }

    public void startAllRoutes() throws Exception {
        this.context.getRouteController().startAllRoutes();
    }

    public boolean canSendToEndpoint(String endpointUri) {
        block8: {
            boolean bl;
            block9: {
                Endpoint endpoint = this.context.getEndpoint(endpointUri);
                if (endpoint == null) break block8;
                Producer producer = endpoint.createProducer();
                try {
                    boolean bl2 = bl = producer != null;
                    if (producer == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (producer != null) {
                            try {
                                producer.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                producer.close();
            }
            return bl;
        }
        return false;
    }

    public void sendBody(String endpointUri, Object body) throws Exception {
        try (ProducerTemplate template = this.context.createProducerTemplate();){
            template.sendBody(endpointUri, body);
        }
    }

    public void sendStringBody(String endpointUri, String body) throws Exception {
        this.sendBody(endpointUri, body);
    }

    public void sendBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers) throws Exception {
        try (ProducerTemplate template = this.context.createProducerTemplate();){
            template.sendBodyAndHeaders(endpointUri, body, headers);
        }
    }

    public Object requestBody(String endpointUri, Object body) throws Exception {
        try (ProducerTemplate template = this.context.createProducerTemplate();){
            Object object = template.requestBody(endpointUri, body);
            return object;
        }
    }

    public Object requestStringBody(String endpointUri, String body) throws Exception {
        return this.requestBody(endpointUri, body);
    }

    public Object requestBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers) throws Exception {
        try (ProducerTemplate template = this.context.createProducerTemplate();){
            Object object = template.requestBodyAndHeaders(endpointUri, body, headers);
            return object;
        }
    }

    public String dumpRestsAsXml() throws Exception {
        return this.dumpRestsAsXml(false);
    }

    public String dumpRestsAsXml(boolean resolvePlaceholders) throws Exception {
        List rests = ((Model)this.context.getCamelContextExtension().getContextPlugin(Model.class)).getRestDefinitions();
        if (rests.isEmpty()) {
            return null;
        }
        RestsDefinition def = new RestsDefinition();
        def.setRests(rests);
        return PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml(this.context, (NamedNode)def, resolvePlaceholders, true);
    }

    public String dumpRoutesAsXml() throws Exception {
        return this.dumpRoutesAsXml(false, true);
    }

    public String dumpRoutesAsXml(boolean resolvePlaceholders) throws Exception {
        return this.dumpRoutesAsXml(resolvePlaceholders, true);
    }

    public String dumpRoutesAsXml(boolean resolvePlaceholders, boolean generatedIds) throws Exception {
        List routes = ((Model)this.context.getCamelContextExtension().getContextPlugin(Model.class)).getRouteDefinitions();
        if (routes.isEmpty()) {
            return null;
        }
        RoutesDefinition def = new RoutesDefinition();
        def.setRoutes(routes);
        if (this.context.isDebugging().booleanValue()) {
            generatedIds = true;
        }
        return PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml(this.context, (NamedNode)def, resolvePlaceholders, generatedIds);
    }

    public String dumpRoutesAsYaml() throws Exception {
        return this.dumpRoutesAsYaml(false, false);
    }

    public String dumpRoutesAsYaml(boolean resolvePlaceholders) throws Exception {
        return this.dumpRoutesAsYaml(resolvePlaceholders, false, true);
    }

    public String dumpRoutesAsYaml(boolean resolvePlaceholders, boolean uriAsParameters) throws Exception {
        return this.dumpRoutesAsYaml(resolvePlaceholders, uriAsParameters, true);
    }

    public String dumpRoutesAsYaml(boolean resolvePlaceholders, boolean uriAsParameters, boolean generatedIds) throws Exception {
        List routes = ((Model)this.context.getCamelContextExtension().getContextPlugin(Model.class)).getRouteDefinitions();
        if (routes.isEmpty()) {
            return null;
        }
        RoutesDefinition def = new RoutesDefinition();
        def.setRoutes(routes);
        if (this.context.isDebugging().booleanValue()) {
            generatedIds = true;
        }
        return PluginHelper.getModelToYAMLDumper((CamelContext)this.context).dumpModelAsYaml(this.context, (NamedNode)def, resolvePlaceholders, uriAsParameters, generatedIds);
    }

    public String dumpRouteTemplatesAsXml() throws Exception {
        List templates = ((Model)this.context.getCamelContextExtension().getContextPlugin(Model.class)).getRouteTemplateDefinitions();
        if (templates.isEmpty()) {
            return null;
        }
        RouteTemplatesDefinition def = new RouteTemplatesDefinition();
        def.setRouteTemplates(templates);
        return PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml(this.context, (NamedNode)def);
    }

    public String dumpRoutesStatsAsXml(boolean fullStats, boolean includeProcessors) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<camelContextStat").append(String.format(" id=\"%s\" state=\"%s\"", this.getCamelId(), this.getState()));
        String stat = this.dumpStatsAsXml(fullStats);
        sb.append(" exchangesInflight=\"").append(this.getInflightExchanges()).append("\"");
        sb.append(" ").append(stat, 7, stat.length() - 2).append(">\n");
        MBeanServer server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer();
        if (server != null) {
            String prefix = this.getContext().getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
            ObjectName query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=routes,*");
            Set<ObjectName> routes = server.queryNames(query, null);
            ArrayList<ManagedProcessorMBean> processors = new ArrayList<ManagedProcessorMBean>();
            if (includeProcessors) {
                query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=processors,*");
                Set<ObjectName> names = server.queryNames(query, null);
                for (ObjectName on : names) {
                    ManagedProcessorMBean processor = (ManagedProcessorMBean)this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedProcessorMBean.class);
                    processors.add(processor);
                }
            }
            processors.sort(new OrderProcessorMBeans());
            sb.append("  <routeStats>\n");
            for (ObjectName on : routes) {
                ManagedRouteMBean route = (ManagedRouteMBean)this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedRouteMBean.class);
                sb.append("    <routeStat").append(String.format(" id=\"%s\" state=\"%s\"", route.getRouteId(), route.getState()));
                if (route.getSourceLocation() != null) {
                    sb.append(String.format(" sourceLocation=\"%s\"", route.getSourceLocation()));
                }
                stat = route.dumpStatsAsXml(fullStats);
                sb.append(" exchangesInflight=\"").append(route.getExchangesInflight()).append("\"");
                sb.append(" ").append(stat, 7, stat.length() - 2).append(">\n");
                if (includeProcessors) {
                    sb.append("      <processorStats>\n");
                    for (ManagedProcessorMBean processor : processors) {
                        int line;
                        int n = line = processor.getSourceLineNumber() != null ? processor.getSourceLineNumber() : -1;
                        if (!route.getRouteId().equals(processor.getRouteId())) continue;
                        sb.append("        <processorStat").append(String.format(" id=\"%s\" index=\"%s\" state=\"%s\" sourceLineNumber=\"%s\"", processor.getProcessorId(), processor.getIndex(), processor.getState(), line));
                        stat = processor.dumpStatsAsXml(fullStats);
                        sb.append(" exchangesInflight=\"").append(processor.getExchangesInflight()).append("\"");
                        sb.append(" ").append(stat, 7, stat.length()).append("\n");
                    }
                    sb.append("      </processorStats>\n");
                }
                sb.append("    </routeStat>\n");
            }
            sb.append("  </routeStats>\n");
        }
        sb.append("</camelContextStat>");
        return sb.toString();
    }

    public String dumpStepStatsAsXml(boolean fullStats) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<camelContextStat").append(String.format(" id=\"%s\" state=\"%s\"", this.getCamelId(), this.getState()));
        String stat = this.dumpStatsAsXml(fullStats);
        sb.append(" exchangesInflight=\"").append(this.getInflightExchanges()).append("\"");
        sb.append(" ").append(stat, 7, stat.length() - 2).append(">\n");
        MBeanServer server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer();
        if (server != null) {
            String prefix = this.getContext().getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
            ObjectName query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=routes,*");
            Set<ObjectName> routes = server.queryNames(query, null);
            ArrayList<Object> steps = new ArrayList<Object>();
            query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=steps,*");
            Set<ObjectName> names = server.queryNames(query, null);
            for (ObjectName on : names) {
                ManagedStepMBean step = (ManagedStepMBean)this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedStepMBean.class);
                steps.add(step);
            }
            steps.sort(new OrderProcessorMBeans());
            sb.append("  <routeStats>\n");
            for (ObjectName on : routes) {
                ManagedRouteMBean route = (ManagedRouteMBean)this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedRouteMBean.class);
                sb.append("    <routeStat").append(String.format(" id=\"%s\" state=\"%s\"", route.getRouteId(), route.getState()));
                if (route.getSourceLocation() != null) {
                    sb.append(String.format(" sourceLocation=\"%s\"", route.getSourceLocation()));
                }
                stat = route.dumpStatsAsXml(fullStats);
                sb.append(" exchangesInflight=\"").append(route.getExchangesInflight()).append("\"");
                sb.append(" ").append(stat, 7, stat.length() - 2).append(">\n");
                sb.append("      <stepStats>\n");
                for (ManagedProcessorMBean managedProcessorMBean : steps) {
                    if (route.getRouteId().equals(managedProcessorMBean.getRouteId())) {
                        int line = managedProcessorMBean.getSourceLineNumber() != null ? managedProcessorMBean.getSourceLineNumber() : -1;
                        sb.append("        <stepStat").append(String.format(" id=\"%s\" index=\"%s\" state=\"%s\" sourceLineNumber=\"%s\"", managedProcessorMBean.getProcessorId(), managedProcessorMBean.getIndex(), managedProcessorMBean.getState(), line));
                        stat = managedProcessorMBean.dumpStatsAsXml(fullStats);
                        sb.append(" exchangesInflight=\"").append(managedProcessorMBean.getExchangesInflight()).append("\"");
                        sb.append(" ").append(stat, 7, stat.length()).append("\n");
                    }
                    sb.append("      </stepStats>\n");
                }
                sb.append("    </stepStat>\n");
            }
            sb.append("  </routeStats>\n");
        }
        sb.append("</camelContextStat>");
        return sb.toString();
    }

    public String dumpRoutesCoverageAsXml() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<camelContextRouteCoverage").append(String.format(" id=\"%s\" exchangesTotal=\"%s\" totalProcessingTime=\"%s\"", this.getCamelId(), this.getExchangesTotal(), this.getTotalProcessingTime())).append(">\n");
        String xml = this.dumpRoutesAsXml(false, false);
        if (xml != null) {
            Document dom = RouteCoverageXmlParser.parseXml(this.context, new ByteArrayInputStream(xml.getBytes()));
            String converted = (String)this.context.getTypeConverter().convertTo(String.class, (Object)dom);
            sb.append(converted);
        }
        sb.append("\n</camelContextRouteCoverage>");
        return sb.toString();
    }

    public boolean createEndpoint(String uri) throws Exception {
        if (this.context.hasEndpoint(uri) != null) {
            return false;
        }
        Endpoint endpoint = this.context.getEndpoint(uri);
        if (endpoint != null) {
            ObjectName on = this.context.getManagementStrategy().getManagementObjectNameStrategy().getObjectNameForEndpoint(endpoint);
            if (on != null && !this.context.getManagementStrategy().getManagementAgent().isRegistered(on)) {
                Object me = this.context.getManagementStrategy().getManagementObjectStrategy().getManagedObjectForEndpoint(this.context, endpoint);
                this.context.getManagementStrategy().getManagementAgent().register(me, on);
            }
            return true;
        }
        return false;
    }

    public int removeEndpoints(String pattern) throws Exception {
        Collection removed = this.context.removeEndpoints(pattern);
        return removed.size();
    }

    public void reset(boolean includeRoutes) throws Exception {
        MBeanServer server;
        this.reset();
        this.load.reset();
        this.thp.reset();
        if (includeRoutes && (server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer()) != null) {
            String prefix = this.getContext().getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
            ObjectName query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=routes,*");
            Set<ObjectName> names = server.queryNames(query, null);
            for (ObjectName name : names) {
                server.invoke(name, "reset", new Object[]{true}, new String[]{"boolean"});
            }
        }
    }

    public Set<String> componentNames() throws Exception {
        return this.context.getComponentNames();
    }

    public Set<String> languageNames() throws Exception {
        return this.context.getLanguageNames();
    }

    public Set<String> dataFormatNames() throws Exception {
        return this.context.getDataFormatNames();
    }

    private static final class OrderProcessorMBeans
    implements Comparator<ManagedProcessorMBean> {
        private OrderProcessorMBeans() {
        }

        @Override
        public int compare(ManagedProcessorMBean o1, ManagedProcessorMBean o2) {
            return o1.getIndex().compareTo(o2.getIndex());
        }
    }
}

