/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.Map;
import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeProperties;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.DynamicRouterDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled(value="CAMEL-8086: used for manual testing a memory issue")
public class DynamicRouterConvertBodyToIssueManualTest
extends ContextTestSupport
implements Processor {
    private static final int MAX_ITERATIONS = 1000;
    private static int counter;

    @Test
    public void testIssue() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Hello World");
        Thread.sleep(60000L);
    }

    protected boolean useJmx() {
        return true;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((DynamicRouterDefinition)this.from("seda:foo").dynamicRouter().method(DynamicRouterConvertBodyToIssueManualTest.class, "slip")).to("mock:result");
                ((RouteDefinition)this.from("direct:while_body").process((Processor)new DynamicRouterConvertBodyToIssueManualTest())).convertBodyTo(String.class);
            }
        };
    }

    public void process(Exchange exchange) throws Exception {
        this.log.info("Some: {}", (Object)counter);
        exchange.setProperty("EXIT", (Object)"NO");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10000; ++i) {
            sb.append(UUID.randomUUID());
        }
        exchange.getIn().setBody((Object)sb);
        Thread.sleep(100L);
        if (counter++ > 1000) {
            exchange.setProperty("EXIT", (Object)"PLEASE");
        }
    }

    public String slip(String body, @ExchangeProperties Map<String, Object> properties) {
        this.log.info("slip {}", properties.get("EXIT"));
        if (properties.get("EXIT") != null && properties.get("EXIT").equals("PLEASE")) {
            this.log.info("Exiting after {} iterations", (Object)1000);
            return null;
        }
        return "direct:while_body";
    }
}

