/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.TimerListener;
import org.apache.camel.management.mbean.LoadTriplet;
import org.apache.camel.support.TimerListenerManager;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class LoadTimerTest
extends ContextTestSupport {
    private static final int SAMPLES = 2;

    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testTimer() {
        TimerListenerManager myTimer = new TimerListenerManager();
        myTimer.setCamelContext((CamelContext)this.context);
        myTimer.start();
        TestLoadAware test = new TestLoadAware();
        myTimer.addTimerListener((TimerListener)test);
        try {
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
                Assertions.assertTrue((test.counter.intValue() >= 2 ? 1 : 0) != 0);
                Assertions.assertFalse((boolean)Double.isNaN(test.load.getLoad1()));
                Assertions.assertTrue((test.load.getLoad1() > 0.0 ? 1 : 0) != 0);
                Assertions.assertTrue((test.load.getLoad1() < 2.0 ? 1 : 0) != 0);
            });
        }
        finally {
            myTimer.removeTimerListener((TimerListener)test);
        }
        myTimer.stop();
    }

    private static class TestLoadAware
    implements TimerListener {
        final LongAdder counter = new LongAdder();
        final LoadTriplet load = new LoadTriplet();

        private TestLoadAware() {
        }

        public void onTimer() {
            this.counter.increment();
            this.load.update(this.counter.intValue());
        }
    }
}

