/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedBeanIntrospectionTest
extends ManagementTestSupport {
    public String getDummy() {
        return "MyDummy";
    }

    @Test
    public void testManageBeanIntrospection() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=services,*"), null);
        ArrayList<ObjectName> list = new ArrayList<ObjectName>(set);
        ObjectName on = null;
        for (ObjectName name : list) {
            if (!name.getCanonicalName().contains("DefaultBeanIntrospection")) continue;
            on = name;
            break;
        }
        Assertions.assertNotNull(on, (String)"Should have found DefaultBeanIntrospection");
        mbeanServer.invoke(on, "resetCounters", null, null);
        Long counter = (Long)mbeanServer.getAttribute(on, "InvokedCounter");
        Assertions.assertEquals((int)0, (int)counter.intValue(), (String)"Should not have been invoked");
        Object dummy = PluginHelper.getBeanIntrospection((CamelContext)this.context).getOrElseProperty((Object)this, "dummy", null, false);
        Assertions.assertEquals((Object)"MyDummy", (Object)dummy);
        counter = (Long)mbeanServer.getAttribute(on, "InvokedCounter");
        Assertions.assertEquals((int)1, (int)counter.intValue(), (String)"Should have been invoked");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

