/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedBrowsableEndpointTest
extends ManagementTestSupport {
    @Test
    public void testBrowseableEndpoint() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = this.getCamelObjectName("endpoints", "mock://result");
        String uri = (String)mbeanServer.getAttribute(name, "EndpointUri");
        Assertions.assertEquals((Object)"mock://result", (Object)uri);
        Long size = (Long)mbeanServer.invoke(name, "queueSize", null, null);
        Assertions.assertEquals((long)2L, (long)size);
        String out = (String)mbeanServer.invoke(name, "browseExchange", new Object[]{0}, new String[]{"java.lang.Integer"});
        Assertions.assertNotNull((Object)out);
        Assertions.assertFalse((boolean)out.contains("Hello World"));
        out = (String)mbeanServer.invoke(name, "browseExchange", new Object[]{1}, new String[]{"java.lang.Integer"});
        Assertions.assertNotNull((Object)out);
        Assertions.assertFalse((boolean)out.contains("Bye World"));
        out = (String)mbeanServer.invoke(name, "browseMessageBody", new Object[]{1}, new String[]{"java.lang.Integer"});
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"Bye World", (Object)out);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

