/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.w3c.dom.Document;

@DisabledOnOs(value={OS.AIX})
public class ManagedRouteDumpStatsAsXmlCustomDomainTest
extends ManagementTestSupport {
    private static final String CUSTOM_DOMAIN_NAME = "custom";

    @Test
    public void testPerformanceCounterStats() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("custom:context=" + this.context.getManagementName() + ",type=routes,name=\"foo\"");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.asyncSendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String xml = (String)mbeanServer.invoke(on, "dumpRouteStatsAsXml", new Object[]{false, true}, new String[]{"boolean", "boolean"});
        this.log.info(xml);
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)xml);
        Assertions.assertNotNull((Object)doc);
        int processors = doc.getDocumentElement().getElementsByTagName("processorStat").getLength();
        Assertions.assertEquals((int)3, (int)processors);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.getContext().getManagementStrategy().getManagementAgent().setMBeanObjectDomainName(ManagedRouteDumpStatsAsXmlCustomDomainTest.CUSTOM_DOMAIN_NAME);
                ((ExpressionNode)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").to("log:foo")).id("to-log")).delay(100L).to("mock:result")).id("to-mock");
            }
        };
    }
}

