/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedRouteNoAutoStartupTest
extends ManagementTestSupport {
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").noAutoStartup().to("mock:result");
            }
        };
    }

    static ObjectName getRouteObjectName(MBeanServer mbeanServer) throws Exception {
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        Assertions.assertEquals((int)1, (int)set.size());
        return set.iterator().next();
    }

    @Test
    public void testRouteNoAutoStartup() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteNoAutoStartupTest.getRouteObjectName(mbeanServer);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Stopped.name(), (Object)state, (String)"Should be stopped");
        mbeanServer.invoke(on, "start", null, null);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
            Assertions.assertEquals((long)1L, (long)completed);
        });
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        Assertions.assertEquals((int)1, (int)set.size(), (String)"Should be 1 consumer");
        set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        Assertions.assertEquals((int)1, (int)set.size(), (String)"Should be 1 processor");
        mbeanServer.invoke(on, "stop", null, null);
        state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Stopped.name(), (Object)state, (String)"Should be stopped");
        set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        Assertions.assertEquals((int)0, (int)set.size(), (String)"Should be 0 consumer");
        set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        Assertions.assertEquals((int)0, (int)set.size(), (String)"Should be 0 processor");
    }
}

