/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedRouteRemoveWireTapExplicitThreadPoolTest
extends ManagementTestSupport {
    private ExecutorService myThreadPool;

    @Test
    public void testRemove() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("routes", "foo");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:tap").expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state, (String)"Should be started");
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=threadpools,*"), null);
        boolean wireTap = false;
        for (ObjectName name : set) {
            if (!name.toString().contains("wireTap")) continue;
            wireTap = true;
            break;
        }
        Assertions.assertFalse((boolean)wireTap, (String)"Should not have a wire tap thread pool");
        mbeanServer.invoke(on, "stop", null, null);
        state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Stopped.name(), (Object)state, (String)"Should be stopped");
        mbeanServer.invoke(on, "remove", null, null);
        boolean registered = mbeanServer.isRegistered(on);
        Assertions.assertFalse((boolean)registered, (String)"Route mbean should have been unregistered");
        set = mbeanServer.queryNames(new ObjectName("*:type=threadpools,*"), null);
        wireTap = false;
        for (ObjectName name : set) {
            if (!name.toString().contains("wireTap")) continue;
            wireTap = true;
            break;
        }
        Assertions.assertFalse((boolean)wireTap, (String)"Should not have a wire tap thread pool");
        Assertions.assertFalse((boolean)this.myThreadPool.isShutdown(), (String)"Thread pool should not be shutdown");
        this.myThreadPool.shutdownNow();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ManagedRouteRemoveWireTapExplicitThreadPoolTest.this.myThreadPool = Executors.newFixedThreadPool(1);
                this.from("seda:foo").routeId("foo").wireTap("direct:tap").executorService(ManagedRouteRemoveWireTapExplicitThreadPoolTest.this.myThreadPool).to("mock:result");
                this.from("direct:tap").routeId("tap").to("mock:tap");
            }
        };
    }
}

