/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ServiceStatus;
import org.apache.camel.api.management.mbean.ManagedThrottlingExceptionRoutePolicyMBean;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.throttling.ThrottlingExceptionHalfOpenHandler;
import org.apache.camel.throttling.ThrottlingExceptionRoutePolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedThrottlingExceptionRoutePolicyTest
extends ManagementTestSupport {
    @Test
    public void testRoutes() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        Assertions.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        boolean registered = mbeanServer.isRegistered(on);
        Assertions.assertTrue((boolean)registered, (String)"Should be registered");
        String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
        Assertions.assertEquals((Object)"direct://start", (Object)uri);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        String policy = (String)mbeanServer.getAttribute(on, "RoutePolicyList");
        Assertions.assertNotNull((Object)policy);
        Assertions.assertTrue((boolean)policy.startsWith("ThrottlingExceptionRoutePolicy"));
        String mbeanName = String.format("org.apache.camel:context=" + this.context.getManagementName() + ",name=%s,type=services", policy);
        set = mbeanServer.queryNames(new ObjectName(mbeanName), null);
        Assertions.assertEquals((int)1, (int)set.size());
        on = set.iterator().next();
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on));
        String myType = (String)mbeanServer.getAttribute(on, "ServiceType");
        Assertions.assertEquals((Object)"ThrottlingExceptionRoutePolicy", (Object)myType);
        ManagedThrottlingExceptionRoutePolicyMBean proxy = JMX.newMBeanProxy(mbeanServer, on, ManagedThrottlingExceptionRoutePolicyMBean.class);
        Assertions.assertNotNull((Object)proxy);
        String myState = proxy.currentState();
        Assertions.assertEquals((Object)"State closed, failures 0", (Object)myState);
        String[] types = proxy.getExceptionTypes();
        Assertions.assertEquals((int)2, (int)types.length);
        Assertions.assertEquals((Object)"java.io.IOException", (Object)types[0]);
        Assertions.assertEquals((Object)"java.lang.UnsupportedOperationException", (Object)types[1]);
        Integer val = proxy.getCurrentFailures();
        Assertions.assertEquals((int)0, (int)val);
        Long lastFail = proxy.getLastFailure();
        Assertions.assertEquals((long)0L, (long)lastFail);
        Long openAt = proxy.getOpenAt();
        Assertions.assertEquals((long)0L, (long)openAt);
        String handlerClass = proxy.getHalfOpenHandlerName();
        Assertions.assertEquals((Object)"DummyHandler", (Object)handlerClass);
        Integer threshold = proxy.getFailureThreshold();
        Assertions.assertEquals((int)10, (int)threshold);
        Long window = proxy.getFailureWindow();
        Assertions.assertEquals((long)1000L, (long)window);
        Long halfOpenAfter = proxy.getHalfOpenAfter();
        Assertions.assertEquals((long)5000L, (long)halfOpenAfter);
        proxy.setHalfOpenAfter(Long.valueOf(10000L));
        halfOpenAfter = proxy.getHalfOpenAfter();
        Assertions.assertEquals((long)10000L, (long)halfOpenAfter);
        try {
            this.getMockEndpoint("mock:result").expectedMessageCount(0);
            this.template.sendBody("direct:start", (Object)"Hello World");
            this.assertMockEndpointsSatisfied();
        }
        catch (Exception exception) {
            // empty catch block
        }
        myState = proxy.currentState();
        Assertions.assertTrue((boolean)myState.contains("State closed, failures 1, last failure"));
        val = proxy.getCurrentFailures();
        Assertions.assertEquals((int)1, (int)val);
        Thread.sleep(200L);
        lastFail = proxy.getLastFailure();
        Assertions.assertTrue((lastFail > 0L ? 1 : 0) != 0);
    }

    protected RouteBuilder createRouteBuilder() {
        final ThrottlingExceptionRoutePolicy policy = new ThrottlingExceptionRoutePolicy(10, 1000L, 5000L, List.of(IOException.class, UnsupportedOperationException.class));
        policy.setHalfOpenHandler((ThrottlingExceptionHalfOpenHandler)new DummyHandler());
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("testRoute").routePolicy(new RoutePolicy[]{policy}).to("log:foo")).process((Processor)new BoomProcess())).to("mock:result");
            }
        };
    }

    static class DummyHandler
    implements ThrottlingExceptionHalfOpenHandler {
        DummyHandler() {
        }

        public boolean isReadyToBeClosed() {
            return false;
        }
    }

    static class BoomProcess
    implements Processor {
        BoomProcess() {
        }

        public void process(Exchange exchange) throws Exception {
            Thread.sleep(50L);
            throw new IOException("boom!");
        }
    }
}

