/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NoErrorHandlerTest
extends ContextTestSupport {
    private static int counter;

    @BeforeEach
    public void setUp() throws Exception {
        counter = 0;
        super.setUp();
    }

    protected boolean useJmx() {
        return true;
    }

    @Test
    public void testNoErrorHandler() throws Exception {
        this.doTest();
    }

    @Test
    public void testNoErrorHandlerJMXDisabled() throws Exception {
        this.doTest();
    }

    private void doTest() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Goodday World"});
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.template.sendBody("direct:start", (Object)"Bye World");
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.template.sendBody("direct:start", (Object)"Goodday World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.noErrorHandler());
                ((RouteDefinition)this.from("direct:start").process(exchange -> {
                    if (++counter < 3) {
                        throw new IllegalArgumentException("Forced by unit test");
                    }
                })).to("mock:result");
            }
        };
    }
}

