/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import org.apache.camel.Exchange;
import org.apache.camel.management.PerformanceCounter;

public class DelegatePerformanceCounter
implements PerformanceCounter {
    private PerformanceCounter counter;
    private boolean statisticsEnabled;

    public void setCounter(PerformanceCounter counter) {
        this.counter = counter;
        this.counter.setStatisticsEnabled(this.statisticsEnabled);
    }

    @Override
    public void processExchange(Exchange exchange, String type) {
        if (this.counter != null) {
            this.counter.processExchange(exchange, type);
        }
    }

    @Override
    public void completedExchange(Exchange exchange, long time) {
        if (this.counter != null) {
            this.counter.completedExchange(exchange, time);
        }
    }

    @Override
    public void failedExchange(Exchange exchange) {
        this.counter.failedExchange(exchange);
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.counter != null && this.counter.isStatisticsEnabled();
    }

    @Override
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        if (this.counter != null) {
            this.counter.setStatisticsEnabled(statisticsEnabled);
        } else {
            this.statisticsEnabled = statisticsEnabled;
        }
    }

    public String toString() {
        return this.counter != null ? this.counter.toString() : super.toString();
    }
}

