/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mapstruct;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Service;
import org.apache.camel.component.mapstruct.DefaultMapStructFinder;
import org.apache.camel.component.mapstruct.MapStructMapperFinder;
import org.apache.camel.component.mapstruct.MapstructEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="mapstruct")
public class MapstructComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(MapstructComponent.class);
    @Metadata(label="advanced", autowired=true)
    private MapStructMapperFinder mapStructConverter;
    @Metadata(required=true)
    private String mapperPackageName;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MapstructEndpoint answer = new MapstructEndpoint(uri, (Component)this);
        answer.setClassName(remaining);
        this.setProperties((Endpoint)answer, parameters);
        return answer;
    }

    public MapStructMapperFinder getMapStructConverter() {
        return this.mapStructConverter;
    }

    public void setMapStructConverter(MapStructMapperFinder mapStructConverter) {
        this.mapStructConverter = mapStructConverter;
    }

    public String getMapperPackageName() {
        return this.mapperPackageName;
    }

    public void setMapperPackageName(String mapperPackageName) {
        this.mapperPackageName = mapperPackageName;
    }

    protected void doStart() throws Exception {
        if (this.mapStructConverter == null) {
            this.mapStructConverter = new DefaultMapStructFinder();
            CamelContextAware.trySetCamelContext((Object)this.mapStructConverter, (CamelContext)this.getCamelContext());
            this.mapStructConverter.setMapperPackageName(this.mapperPackageName);
        }
        ServiceHelper.startService((Service)this.mapStructConverter);
        if (this.mapStructConverter.getMapperPackageName() == null) {
            LOG.warn("Cannot find MapStruct Mapper classes because mapperPackageName has not been configured");
        }
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Service)this.mapStructConverter);
    }
}

