/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.master;

import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.StartupListener;
import org.apache.camel.SuspendableService;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.cluster.CamelClusterEventListener;
import org.apache.camel.cluster.CamelClusterMember;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.cluster.CamelClusterView;
import org.apache.camel.component.master.MasterEndpoint;
import org.apache.camel.resume.ResumeAdapter;
import org.apache.camel.resume.ResumeAware;
import org.apache.camel.resume.ResumeStrategy;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.resume.AdapterHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed Master Consumer")
public class MasterConsumer
extends DefaultConsumer
implements ResumeAware {
    private static final transient Logger LOG = LoggerFactory.getLogger(MasterConsumer.class);
    private final CamelClusterService clusterService;
    private final MasterEndpoint masterEndpoint;
    private final Endpoint delegatedEndpoint;
    private final Processor processor;
    private final CamelClusterEventListener.Leadership leadershipListener;
    private volatile Consumer delegatedConsumer;
    private volatile CamelClusterView view;
    private ResumeStrategy resumeStrategy;

    public MasterConsumer(MasterEndpoint masterEndpoint, Processor processor, CamelClusterService clusterService) {
        super((Endpoint)masterEndpoint, processor);
        this.clusterService = clusterService;
        this.masterEndpoint = masterEndpoint;
        this.delegatedEndpoint = masterEndpoint.getEndpoint();
        this.processor = processor;
        this.leadershipListener = new LeadershipListener();
    }

    public ResumeStrategy getResumeStrategy() {
        return this.resumeStrategy;
    }

    public void setResumeStrategy(ResumeStrategy resumeStrategy) {
        this.resumeStrategy = resumeStrategy;
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("Using ClusterService instance {} (id={}, type={})", new Object[]{this.clusterService, this.clusterService.getId(), this.clusterService.getClass().getName()});
        this.view = this.clusterService.getView(this.masterEndpoint.getNamespace());
        this.view.addEventListener((CamelClusterEventListener)this.leadershipListener);
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.view != null) {
            this.view.removeEventListener((CamelClusterEventListener)this.leadershipListener);
            this.clusterService.releaseView(this.view);
            this.view = null;
        }
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.delegatedConsumer, this.delegatedEndpoint});
        this.delegatedConsumer = null;
    }

    protected void doResume() throws Exception {
        if (this.delegatedConsumer instanceof SuspendableService) {
            ((SuspendableService)this.delegatedConsumer).resume();
        }
        super.doResume();
    }

    protected void doSuspend() throws Exception {
        if (this.delegatedConsumer instanceof SuspendableService) {
            ((SuspendableService)this.delegatedConsumer).suspend();
        }
        super.doSuspend();
    }

    @ManagedAttribute(description="Are we the master")
    public boolean isMaster() {
        return this.view != null && this.view.getLocalMember().isLeader();
    }

    private synchronized void onLeadershipTaken() throws Exception {
        Consumer consumer;
        if (!this.isRunAllowed()) {
            return;
        }
        if (this.delegatedConsumer != null) {
            return;
        }
        this.delegatedConsumer = this.delegatedEndpoint.createConsumer(this.processor);
        if (this.delegatedConsumer instanceof StartupListener) {
            this.getEndpoint().getCamelContext().addStartupListener((StartupListener)this.delegatedConsumer);
        }
        if ((consumer = this.delegatedConsumer) instanceof ResumeAware) {
            ResumeAware resumeAwareConsumer = (ResumeAware)consumer;
            if (this.resumeStrategy != null) {
                LOG.info("Setting up the resume adapter for the resume strategy in the delegated consumer");
                ResumeAdapter resumeAdapter = AdapterHelper.eval((CamelContext)this.clusterService.getCamelContext(), (ResumeAware)resumeAwareConsumer, (ResumeStrategy)this.resumeStrategy);
                this.resumeStrategy.setAdapter(resumeAdapter);
                LOG.info("Setting up the resume strategy for the delegated consumer");
                resumeAwareConsumer.setResumeStrategy(this.resumeStrategy);
            }
        }
        ServiceHelper.startService((Object[])new Object[]{this.delegatedEndpoint, this.delegatedConsumer});
        LOG.info("Leadership taken. Consumer started: {}", (Object)this.delegatedEndpoint);
    }

    private synchronized void onLeadershipLost() {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.delegatedConsumer, this.delegatedEndpoint});
        this.delegatedConsumer = null;
        LOG.info("Leadership lost. Consumer stopped: {}", (Object)this.delegatedEndpoint);
    }

    private final class LeadershipListener
    implements CamelClusterEventListener.Leadership {
        private LeadershipListener() {
        }

        public void leadershipChanged(CamelClusterView view, Optional<CamelClusterMember> leader) {
            if (!MasterConsumer.this.isRunAllowed()) {
                return;
            }
            if (view.getLocalMember().isLeader()) {
                try {
                    MasterConsumer.this.onLeadershipTaken();
                }
                catch (Exception e) {
                    MasterConsumer.this.getExceptionHandler().handleException("Error starting consumer while taking leadership", (Throwable)e);
                }
            } else if (MasterConsumer.this.delegatedConsumer != null) {
                try {
                    MasterConsumer.this.onLeadershipLost();
                }
                catch (Exception e) {
                    MasterConsumer.this.getExceptionHandler().handleException("Error stopping consumer while loosing leadership. This exception is ignored.", (Throwable)e);
                }
            }
        }
    }
}

